
/* File:        org.molgenis.omx/model/OntologyTerm.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ.target;

/**
 * OntologyTerm: 
				OntologyTerm defines a single entry (term) from an
				ontology or a controlled vocabulary (defined by Ontology). The
				identifier is the ontology term is unique. E.g. 'NCI:Antigen Gene'.
				Other data entities can reference to this OntologyTerm to harmonize
				naming of concepts. If no suitable ontology term exists then one can
				define new terms locally (in which case there is no formal accession
				for the term limiting its use for cross-Investigation queries).
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "OntologyTerm", uniqueConstraints={ @javax.persistence.UniqueConstraint( columnNames={ "ontology", "termAccession" } ) }
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.observ.target.db.OntologyTermEntityListener.class})
public class OntologyTerm extends org.molgenis.omx.observ.Characteristic 
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String ONTOLOGY = "ontology";
	public final static String ONTOLOGY_IDENTIFIER = "ontology_Identifier";
	public final static String TERMACCESSION = "termAccession";
	public final static String DEFINITION = "definition";
	public final static String ID = "id";
	
	//static methods
	/**
	 * Shorthand for db.query(OntologyTerm.class).
	 */
	public static org.molgenis.framework.db.Query<? extends OntologyTerm> query(org.molgenis.framework.db.Database db)
	{
		return db.query(OntologyTerm.class);
	}
	
	/**
	 * Shorthand for db.find(OntologyTerm.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends OntologyTerm> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(OntologyTerm.class, rules);
	}	
	
	/**
	 * 
	 */
	public static OntologyTerm findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<OntologyTerm> q = db.query(OntologyTerm.class);
		q.eq(OntologyTerm.ID, id);
		java.util.List<OntologyTerm> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static OntologyTerm findByIdentifier(org.molgenis.framework.db.Database db, String identifier) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<OntologyTerm> q = db.query(OntologyTerm.class);
		q.eq(OntologyTerm.IDENTIFIER, identifier);
		java.util.List<OntologyTerm> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static OntologyTerm findByOntologyTermAccession(org.molgenis.framework.db.Database db, Integer ontology, String termAccession) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<OntologyTerm> q = db.query(OntologyTerm.class);
		q.eq(OntologyTerm.ONTOLOGY, ontology);q.eq(OntologyTerm.TERMACCESSION, termAccession);
		java.util.List<OntologyTerm> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//(Optional) The source ontology or controlled vocabulary list that ontology terms have been obtained from.[type=xref]
//	@org.hibernate.search.annotations.Field(index=org.hibernate.search.annotations.Index.TOKENIZED, store=org.hibernate.search.annotations.Store.NO)
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ontology")   	
	
				

	private org.molgenis.omx.observ.target.Ontology ontology = null;
	@javax.persistence.Transient
	private Integer ontology_id = null;	
	@javax.persistence.Transient
	private String ontology_Identifier = null;						

	//(Optional) The accession number assigned to the ontology term in its source ontology. If empty it is assumed to be a locally defined term.[type=string]
//	@org.hibernate.search.annotations.Field(index=org.hibernate.search.annotations.Index.TOKENIZED, store=org.hibernate.search.annotations.Store.NO)
	@javax.persistence.Column(name="termAccession", length=255)
	@javax.xml.bind.annotation.XmlElement(name="termAccession")
	
				

	private String termAccession =  null;

	//(Optional) The definition of the term.[type=string]
	@javax.persistence.Column(name="definition", length=255)
	@javax.xml.bind.annotation.XmlElement(name="definition")
	
				

	private String definition =  null;

	//automatically generated internal id, only for internal use.[type=int]
	

	//constructors
	public OntologyTerm()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	/** copy constructor */
	public OntologyTerm(OntologyTerm copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the (Optional) The source ontology or controlled vocabulary list that ontology terms have been obtained from..
	 * @return ontology.
	 */
	public org.molgenis.omx.observ.target.Ontology getOntology()
	{
		return this.ontology;
	}
	
	@Deprecated
	public org.molgenis.omx.observ.target.Ontology getOntology(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the (Optional) The source ontology or controlled vocabulary list that ontology terms have been obtained from..
	 * @param ontology
	 */
	public void setOntology( org.molgenis.omx.observ.target.Ontology ontology)
	{
		
		this.ontology = ontology;
	}

	
	
	/**
	 * Set foreign key for field ontology.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setOntology_Id(Integer ontology_id)
	{
		this.ontology_id = ontology_id;
	}	

	public void setOntology(Integer ontology_id)
	{
		this.ontology_id = ontology_id;
	}
	
	public Integer getOntology_Id()
	{
		
		if(ontology != null) 
		{
			return ontology.getId();
		}
		else
		{
			return ontology_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference Ontology to Ontology.Id.
	 */
	public String getOntology_Identifier()
	{		
		//FIXME should we auto-load based on getOntology()?	
		if(ontology != null) {
			return ontology.getIdentifier();
		} else {
			return ontology_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Ontology to <a href="Ontology.html#Id">Ontology.Id</a>.
	 * Implies setOntology(null) until save
	 */
	public void setOntology_Identifier(String ontology_Identifier)
	{
		this.ontology_Identifier = ontology_Identifier;
	}		
	 
	

	/**
	 * Get the (Optional) The accession number assigned to the ontology term in its source ontology. If empty it is assumed to be a locally defined term..
	 * @return termAccession.
	 */
	public String getTermAccession()
	{
		return this.termAccession;
	}
	
	@Deprecated
	public String getTermAccession(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the (Optional) The accession number assigned to the ontology term in its source ontology. If empty it is assumed to be a locally defined term..
	 * @param termAccession
	 */
	public void setTermAccession( String termAccession)
	{
		
		this.termAccession = termAccession;
	}

	

	/**
	 * Get the (Optional) The definition of the term..
	 * @return definition.
	 */
	public String getDefinition()
	{
		return this.definition;
	}
	
	@Deprecated
	public String getDefinition(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the (Optional) The definition of the term..
	 * @param definition
	 */
	public void setDefinition( String definition)
	{
		
		this.definition = definition;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();
		if (name.equals("description"))
			return getDescription();
		if (name.equals("ontology"))
			return getOntology();
		if(name.equals("ontology_id"))
			return getOntology_Id();
		if(name.equals("ontology_identifier"))
			return getOntology_Identifier();
		if (name.equals("termaccession"))
			return getTermAccession();
		if (name.equals("definition"))
			return getDefinition();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getIdentifier() == null) throw new org.molgenis.framework.db.DatabaseException("required field identifier is null");
		if(this.getName() == null) throw new org.molgenis.framework.db.DatabaseException("required field name is null");
		if(this.get__Type() == null) throw new org.molgenis.framework.db.DatabaseException("required field __Type is null");
	}
	
	@Override
	public void set(org.molgenis.util.tuple.Tuple tuple, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(tuple.getInt("id") != null) this.setId(tuple.getInt("id"));
		else if(tuple.getInt("id") != null) this.setId(tuple.getInt("id"));
		else if(strict) this.setId(tuple.getInt("id")); // setting null is not an option due to function overloading
		if( tuple.getInt("ontologyterm_id") != null) this.setId(tuple.getInt("ontologyterm_id"));
		else if( tuple.getInt("OntologyTerm_id") != null) this.setId(tuple.getInt("OntologyTerm_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(tuple.getString("identifier") != null) this.setIdentifier(tuple.getString("identifier"));
		else if(tuple.getString("Identifier") != null) this.setIdentifier(tuple.getString("Identifier"));
		else if(strict) this.setIdentifier(tuple.getString("identifier")); // setting null is not an option due to function overloading
		if( tuple.getString("ontologyterm_identifier") != null) this.setIdentifier(tuple.getString("ontologyterm_identifier"));
		else if( tuple.getString("OntologyTerm_Identifier") != null) this.setIdentifier(tuple.getString("OntologyTerm_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(tuple.getString("name") != null) this.setName(tuple.getString("name"));
		else if(tuple.getString("Name") != null) this.setName(tuple.getString("Name"));
		else if(strict) this.setName(tuple.getString("name")); // setting null is not an option due to function overloading
		if( tuple.getString("ontologyterm_name") != null) this.setName(tuple.getString("ontologyterm_name"));
		else if( tuple.getString("OntologyTerm_Name") != null) this.setName(tuple.getString("OntologyTerm_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(tuple.getString("__type") != null) this.set__Type(tuple.getString("__type"));
		else if(tuple.getString("__Type") != null) this.set__Type(tuple.getString("__Type"));
		else if(strict) this.set__Type(tuple.getString("__type")); // setting null is not an option due to function overloading
		if( tuple.getString("ontologyterm___type") != null) this.set__Type(tuple.getString("ontologyterm___type"));
		else if( tuple.getString("OntologyTerm___Type") != null) this.set__Type(tuple.getString("OntologyTerm___Type"));
		//set Description
		// query formal name, else lowercase name
		if(tuple.getString("description") != null) this.setDescription(tuple.getString("description"));
		else if(tuple.getString("description") != null) this.setDescription(tuple.getString("description"));
		else if(strict) this.setDescription(tuple.getString("description")); // setting null is not an option due to function overloading
		if( tuple.getString("ontologyterm_description") != null) this.setDescription(tuple.getString("ontologyterm_description"));
		else if( tuple.getString("OntologyTerm_description") != null) this.setDescription(tuple.getString("OntologyTerm_description"));
		//set Ontology
		// query formal name, else lowercase name
		if(tuple.getInt("ontology_id") != null) this.setOntology(tuple.getInt("ontology_id"));
		else if(tuple.getInt("ontology_id") != null) this.setOntology(tuple.getInt("ontology_id"));
		else if(strict) this.setOntology(tuple.getInt("ontology_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("OntologyTerm_ontology_id") != null) this.setOntology(tuple.getInt("OntologyTerm_ontology_id"));
		else if( tuple.getInt("ontologyterm_ontology_id") != null) this.setOntology(tuple.getInt("ontologyterm_ontology_id"));
		//alias of xref
		if( tuple.get("ontology") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("ontology").toString())) {
				org.molgenis.omx.observ.target.Ontology instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("ontology"), org.molgenis.omx.observ.target.Ontology.class);
				this.setOntology(instance);				
			} else {
				this.setOntology_Id(tuple.getInt("ontology")); 
			}
		}
		else if( tuple.get("ontology") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("ontology").toString())) {
				org.molgenis.omx.observ.target.Ontology instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("ontology"), org.molgenis.omx.observ.target.Ontology.class);
				this.setOntology(instance);				
			} else {
				this.setOntology_Id(tuple.getInt("ontology"));
			}
		}
		if( tuple.get("OntologyTerm_ontology") != null)
			this.setOntology_Id(tuple.getInt("OntologyTerm_ontology"));			
		else if( tuple.get("ontologyterm_ontology") != null)
			this.setOntology_Id(tuple.getInt("ontologyterm_ontology"));
			
		if( tuple.get("OntologyTerm.ontology") != null) 
			this.setOntology((org.molgenis.omx.observ.target.Ontology)tuple.get("OntologyTerm.ontology_id"));
		else if( tuple.get("ontologyterm.ontology") != null) 
			this.setOntology((org.molgenis.omx.observ.target.Ontology)tuple.get("ontologyterm.ontology_id"));	
		//set label for field Ontology
		if(tuple.get("ontology_Identifier") != null) this.setOntology_Identifier(tuple.getString("ontology_Identifier"));
		else if(tuple.get("ontology_identifier") != null) this.setOntology_Identifier(tuple.getString("ontology_identifier"));
		else if(strict) this.setOntology_Identifier(tuple.getString("ontology_Identifier")); // setting null is not an option due to function overloading
		if( tuple.get("OntologyTerm_ontology_Identifier") != null ) this.setOntology_Identifier(tuple.getString("OntologyTerm_ontology_Identifier"));		
		else if( tuple.get("ontologyterm_ontology_identifier") != null ) this.setOntology_Identifier(tuple.getString("ontologyterm_ontology_identifier"));
		//set TermAccession
		// query formal name, else lowercase name
		if(tuple.getString("termaccession") != null) this.setTermAccession(tuple.getString("termaccession"));
		else if(tuple.getString("termAccession") != null) this.setTermAccession(tuple.getString("termAccession"));
		else if(strict) this.setTermAccession(tuple.getString("termaccession")); // setting null is not an option due to function overloading
		if( tuple.getString("ontologyterm_termaccession") != null) this.setTermAccession(tuple.getString("ontologyterm_termaccession"));
		else if( tuple.getString("OntologyTerm_termAccession") != null) this.setTermAccession(tuple.getString("OntologyTerm_termAccession"));
		//set Definition
		// query formal name, else lowercase name
		if(tuple.getString("definition") != null) this.setDefinition(tuple.getString("definition"));
		else if(tuple.getString("definition") != null) this.setDefinition(tuple.getString("definition"));
		else if(strict) this.setDefinition(tuple.getString("definition")); // setting null is not an option due to function overloading
		if( tuple.getString("ontologyterm_definition") != null) this.setDefinition(tuple.getString("ontologyterm_definition"));
		else if( tuple.getString("OntologyTerm_definition") != null) this.setDefinition(tuple.getString("OntologyTerm_definition"));
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "OntologyTerm(";
		result+= "id='" + getId()+"' ";	
		result+= "identifier='" + getIdentifier()+"' ";	
		result+= "name='" + getName()+"' ";	
		result+= "__Type='" + get__Type()+"' ";	
		result+= "description='" + getDescription()+"' ";	
		result+= " ontology_id='" + getOntology_Id()+"' ";	
		result+= " ontology_identifier='" + getOntology_Identifier()+"' ";
		result+= "termAccession='" + getTermAccession()+"' ";	
		result+= "definition='" + getDefinition()+"'";	
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of OntologyTerm.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Identifier");
		}
		{
			fields.add("Name");
		}
		{
			fields.add("__Type");
		}
		{
			fields.add("description");
		}
		{
			fields.add("ontology_id");
		}
		fields.add("ontology_Identifier");
		{
			fields.add("termAccession");
		}
		{
			fields.add("definition");
		}
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "identifier" +sep
		+ "name" +sep
		+ "__Type" +sep
		+ "description" +sep
		+ "ontology" +sep
		+ "termAccession" +sep
		+ "definition" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("ontology")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdentifier();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = get__Type();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDescription();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getOntology();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getTermAccession();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDefinition();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public OntologyTerm create(org.molgenis.util.tuple.Tuple tuple) throws Exception
	{
		OntologyTerm e = new OntologyTerm();
		e.set(tuple);
		return e;
	}
	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		OntologyTerm other = (OntologyTerm) obj;
		if (ontology == null)
		{
			if (other.ontology != null) return false;
		}
		else if (!ontology.equals(other.ontology)) return false;
		if (termAccession == null)
		{
			if (other.termAccession != null) return false;
		}
		else if (!termAccession.equals(other.termAccession)) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((ontology == null) ? 0 : ontology.hashCode());
		result = prime * result + ((termAccession == null) ? 0 : termAccession.hashCode());
		return result;
	}
}
