
/* File:        org.molgenis.omx/model/Species.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.target.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.target.Ontology;
import org.molgenis.omx.observ.target.Species;


/**
 * Reads Species from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class SpeciesEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(SpeciesEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'ontology' (maps ontology.Identifier -> ontology.id)			
	final Map<String,Integer> ontologyKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Species from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Species> speciessMissingRefs = new ArrayList<Species>();
	
		//cache for objects to be imported from file (in batch)
		final List<Species> speciesList = new ArrayList<Species>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			Species object = new Species();
			object.set(tuple, false);				
			speciesList.add(object);		
			
			//add to db when batch size is reached
			if(speciesList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				speciessMissingRefs.addAll(resolveForeignKeys(db, speciesList));
				speciesList.removeAll(speciessMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(speciesList,dbAction, "Identifier");
				
				//clear for next batch						
				speciesList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!speciesList.isEmpty())
		{
			total.set(total.get() + speciesList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			speciessMissingRefs.addAll(resolveForeignKeys(db, speciesList));
			speciesList.removeAll(speciessMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(speciesList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Species> speciess = new ArrayList<Species>(speciessMissingRefs);

		int iterationCount = 0;

		do
		{
			speciessMissingRefs = resolveForeignKeys(db, speciessMissingRefs);
			
			LinkedHashSet<Species> differenceSet = new LinkedHashSet<Species>();
			Sets.symmetricDifference(new LinkedHashSet<Species>(speciess), new LinkedHashSet<Species>(speciessMissingRefs)).copyInto(differenceSet);
			List<Species> resolvablespeciess = new ArrayList<Species>(differenceSet);
			
			speciess.removeAll(resolvablespeciess);
			
			db.update(resolvablespeciess,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Species blaat : speciessMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'species' entity failed:"
								+ "This is probably caused by a(n) 'species' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (speciessMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " species from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param speciesList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Species> resolveForeignKeys(Database db, List<Species> speciesList) throws Exception
	{
		//keep a list of Species instances that miss a reference which might be resolvable later
		List<Species> speciessMissingRefs = new ArrayList<Species>();
	
		//resolve xref 'ontology' from ontology.Identifier -> ontology.id
		for(Species o: speciesList) 
		{
			if(o.getOntology_Identifier() != null) 
				ontologyKeymap.put(o.getOntology_Identifier(), null);
		}
		
		if(ontologyKeymap.size() > 0) 
		{
			List<Ontology> ontologyList = db.query(Ontology.class).in("Identifier",new ArrayList<Object>(ontologyKeymap.keySet())).find();
			for(Ontology xref :  ontologyList)
			{
				ontologyKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Species o:  speciesList)
		{
			while(true){
				//update xref ontology
				if(o.getOntology_Identifier() != null) 
				{
					String key = o.getOntology_Identifier();
					if(ontologyKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Species' objects failed: cannot find Ontology for ontology_Identifier='"+o.getOntology_Identifier()+"'");
					}
					o.setOntology_Id(ontologyKeymap.get(key));
				}
				break;
			}
		}
		
		ontologyKeymap.clear();
		
		return speciessMissingRefs;
	}
}

