package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.DateValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class DateValueService
{
	private static final Logger logger = Logger.getLogger(DateValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public DateValue create(DateValue dateValue) throws DatabaseException
	{
		logger.debug("creating DateValue");
		db.add(dateValue);
		return dateValue;
	}

	public DateValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving DateValue");
		return db.findById(DateValue.class, id);
	}

	public void update(DateValue dateValue) throws DatabaseException
	{
		logger.debug("updating DateValue");
		db.update(dateValue);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting DateValue");
		DateValue dateValue = db.findById(DateValue.class, id);
		return db.remove(dateValue) == 1;
	}
	
	public Iterable<DateValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all DateValue instances");
		return db.find(DateValue.class);
	}
	
	public EntityPager<DateValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all DateValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(DateValue.class, queryRules.toArray(new QueryRule[0]));
		List<DateValue> dateValueCollection = db.find(DateValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<DateValue>(start, num, count, dateValueCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("DateValue");
	}
}