
/* File:        org.molgenis.omx/model/BoolValue.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.value.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.value.BoolValue;


/**
 * Reads BoolValue from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class BoolValueEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(BoolValueEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports BoolValue from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<BoolValue> boolValuesMissingRefs = new ArrayList<BoolValue>();
	
		//cache for objects to be imported from file (in batch)
		final List<BoolValue> boolValueList = new ArrayList<BoolValue>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			BoolValue object = new BoolValue();
			object.set(tuple, false);				
			boolValueList.add(object);		
			
			//add to db when batch size is reached
			if(boolValueList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				boolValuesMissingRefs.addAll(resolveForeignKeys(db, boolValueList));
				boolValueList.removeAll(boolValuesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
				db.update(boolValueList,dbAction, "id");
				
				//clear for next batch						
				boolValueList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!boolValueList.isEmpty())
		{
			total.set(total.get() + boolValueList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			boolValuesMissingRefs.addAll(resolveForeignKeys(db, boolValueList));
			boolValueList.removeAll(boolValuesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
			db.update(boolValueList,dbAction, "id");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<BoolValue> boolValues = new ArrayList<BoolValue>(boolValuesMissingRefs);

		int iterationCount = 0;

		do
		{
			boolValuesMissingRefs = resolveForeignKeys(db, boolValuesMissingRefs);
			
			LinkedHashSet<BoolValue> differenceSet = new LinkedHashSet<BoolValue>();
			Sets.symmetricDifference(new LinkedHashSet<BoolValue>(boolValues), new LinkedHashSet<BoolValue>(boolValuesMissingRefs)).copyInto(differenceSet);
			List<BoolValue> resolvableboolValues = new ArrayList<BoolValue>(differenceSet);
			
			boolValues.removeAll(resolvableboolValues);
			
			db.update(resolvableboolValues,dbAction, "id");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(BoolValue blaat : boolValuesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'boolValue' entity failed:"
								+ "This is probably caused by a(n) 'boolValue' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (boolValuesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " boolValue from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param boolValueList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<BoolValue> resolveForeignKeys(Database db, List<BoolValue> boolValueList) throws Exception
	{
		//keep a list of BoolValue instances that miss a reference which might be resolvable later
		List<BoolValue> boolValuesMissingRefs = new ArrayList<BoolValue>();
	
		//update objects with foreign key values
		for(BoolValue o:  boolValueList)
		{
			while(true){
				break;
			}
		}
		
		
		return boolValuesMissingRefs;
	}
}

