
/* File:        org.molgenis.omx/model/HyperlinkValue.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.value.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.value.HyperlinkValue;


/**
 * Reads HyperlinkValue from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class HyperlinkValueEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(HyperlinkValueEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports HyperlinkValue from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<HyperlinkValue> hyperlinkValuesMissingRefs = new ArrayList<HyperlinkValue>();
	
		//cache for objects to be imported from file (in batch)
		final List<HyperlinkValue> hyperlinkValueList = new ArrayList<HyperlinkValue>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			HyperlinkValue object = new HyperlinkValue();
			object.set(tuple, false);				
			hyperlinkValueList.add(object);		
			
			//add to db when batch size is reached
			if(hyperlinkValueList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				hyperlinkValuesMissingRefs.addAll(resolveForeignKeys(db, hyperlinkValueList));
				hyperlinkValueList.removeAll(hyperlinkValuesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
				db.update(hyperlinkValueList,dbAction, "id");
				
				//clear for next batch						
				hyperlinkValueList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!hyperlinkValueList.isEmpty())
		{
			total.set(total.get() + hyperlinkValueList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			hyperlinkValuesMissingRefs.addAll(resolveForeignKeys(db, hyperlinkValueList));
			hyperlinkValueList.removeAll(hyperlinkValuesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
			db.update(hyperlinkValueList,dbAction, "id");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<HyperlinkValue> hyperlinkValues = new ArrayList<HyperlinkValue>(hyperlinkValuesMissingRefs);

		int iterationCount = 0;

		do
		{
			hyperlinkValuesMissingRefs = resolveForeignKeys(db, hyperlinkValuesMissingRefs);
			
			LinkedHashSet<HyperlinkValue> differenceSet = new LinkedHashSet<HyperlinkValue>();
			Sets.symmetricDifference(new LinkedHashSet<HyperlinkValue>(hyperlinkValues), new LinkedHashSet<HyperlinkValue>(hyperlinkValuesMissingRefs)).copyInto(differenceSet);
			List<HyperlinkValue> resolvablehyperlinkValues = new ArrayList<HyperlinkValue>(differenceSet);
			
			hyperlinkValues.removeAll(resolvablehyperlinkValues);
			
			db.update(resolvablehyperlinkValues,dbAction, "id");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(HyperlinkValue blaat : hyperlinkValuesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'hyperlinkValue' entity failed:"
								+ "This is probably caused by a(n) 'hyperlinkValue' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (hyperlinkValuesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " hyperlinkValue from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param hyperlinkValueList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<HyperlinkValue> resolveForeignKeys(Database db, List<HyperlinkValue> hyperlinkValueList) throws Exception
	{
		//keep a list of HyperlinkValue instances that miss a reference which might be resolvable later
		List<HyperlinkValue> hyperlinkValuesMissingRefs = new ArrayList<HyperlinkValue>();
	
		//update objects with foreign key values
		for(HyperlinkValue o:  hyperlinkValueList)
		{
			while(true){
				break;
			}
		}
		
		
		return hyperlinkValuesMissingRefs;
	}
}

