
/* File:        org.molgenis.omx/model/Institute.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 14, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.auth.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.auth.Institute;


/**
 * Reads Institute from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class InstituteEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(InstituteEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports Institute from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Institute> institutesMissingRefs = new ArrayList<Institute>();
	
		//cache for objects to be imported from file (in batch)
		final List<Institute> instituteList = new ArrayList<Institute>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Institute object = new Institute();
			object.set(entity, false);				
			instituteList.add(object);		
			
			//add to db when batch size is reached
			if(instituteList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				institutesMissingRefs.addAll(resolveForeignKeys(db, instituteList));
				instituteList.removeAll(institutesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Name' defined in xref_label
				db.update(instituteList,dbAction, "Name");
				
				//clear for next batch						
				instituteList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!instituteList.isEmpty())
		{
			total.set(total.get() + instituteList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			institutesMissingRefs.addAll(resolveForeignKeys(db, instituteList));
			instituteList.removeAll(institutesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Name' defined in xref_label
			db.update(instituteList,dbAction, "Name");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Institute> institutes = new ArrayList<Institute>(institutesMissingRefs);

		int iterationCount = 0;

		do
		{
			institutesMissingRefs = resolveForeignKeys(db, institutesMissingRefs);
			
			LinkedHashSet<Institute> differenceSet = new LinkedHashSet<Institute>();
			Sets.symmetricDifference(new LinkedHashSet<Institute>(institutes), new LinkedHashSet<Institute>(institutesMissingRefs)).copyInto(differenceSet);
			List<Institute> resolvableinstitutes = new ArrayList<Institute>(differenceSet);
			
			institutes.removeAll(resolvableinstitutes);
			
			db.update(resolvableinstitutes,dbAction, "Name");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Institute blaat : institutesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'institute' entity failed:"
								+ "This is probably caused by a(n) 'institute' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (institutesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " institute from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param instituteList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Institute> resolveForeignKeys(Database db, List<Institute> instituteList) throws Exception
	{
		//keep a list of Institute instances that miss a reference which might be resolvable later
		List<Institute> institutesMissingRefs = new ArrayList<Institute>();
	
		//update objects with foreign key values
		for(Institute o:  instituteList)
		{
			while(true){
				break;
			}
		}
		
		
		return institutesMissingRefs;
	}
}

