/* File:        org.molgenis.omx/model/PersonRole.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 14, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.auth.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class PersonRoleJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.auth.PersonRole>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(PersonRoleJpaMapper.class);

	public PersonRoleJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT PersonRole.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", OntologyTerm.ontology"
			+", OntologyTerm.termAccession"
			+", OntologyTerm.definition"
			//parent is SimpleTree(name='ontology')
			+", xref_ontology.Identifier AS ontology_Identifier"
			+" FROM PersonRole "
			+" INNER JOIN OntologyTerm ON (PersonRole.id = OntologyTerm.id)"
			+" INNER JOIN Characteristic ON (PersonRole.id = Characteristic.id)"

			
			//label for ontology=Identifier
//path==ontology. type==xref.
//path==ontology_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Ontology AS xref_ontology " 
			+" ON xref_ontology.id = OntologyTerm.ontology"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.auth.PersonRole entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'ontology' is known in the databse
			if(entity.getOntology() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getOntology().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.OntologyJpaMapper(getDatabase()).create(entity.getOntology());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getOntology()) && entity.getOntology().getIdValue() != null)
					entity.setOntology(getEntityManager().getReference(org.molgenis.omx.observ.target.Ontology.class, entity.getOntology().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getOntology_Id() != null) {
					entity.setOntology((org.molgenis.omx.observ.target.Ontology)getEntityManager().find(org.molgenis.omx.observ.target.Ontology.class, entity.getOntology_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.auth.PersonRole personRole) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				personRole = getEntityManager().getReference(org.molgenis.omx.auth.PersonRole.class, personRole.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The personRole with id " + personRole.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(personRole);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.auth.PersonRole personRole) throws org.molgenis.framework.db.DatabaseException {
		try {







			//1
			org.molgenis.omx.observ.target.Ontology ontologyNew = personRole.getOntology();

			if (ontologyNew == null) { //object is reference by xref		
                            if(personRole.getOntology_Id() != null) {
                                personRole.setOntology((org.molgenis.omx.observ.target.Ontology)getEntityManager().find(org.molgenis.omx.observ.target.Ontology.class, personRole.getOntology_Id()));
                            }
			}


			if(!getEntityManager().contains(personRole)) {
				personRole = getEntityManager().merge(personRole);
			}
			

		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.auth.PersonRole> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.auth.PersonRole personRole : entities) 
			{
				create(personRole);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.auth.PersonRole> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.auth.PersonRole personRole : entities) 
			{
				edit(personRole);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.auth.PersonRole> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.auth.PersonRole personRole : entities) 
			{
				destroy(personRole);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("PersonRole_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("PersonRole_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("PersonRole_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("PersonRole___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("PersonRole_description".equalsIgnoreCase(fieldName)) return "description";
		if("ontology".equalsIgnoreCase(fieldName)) return "ontology";
		if("PersonRole_ontology".equalsIgnoreCase(fieldName)) return "ontology";
		if("termAccession".equalsIgnoreCase(fieldName)) return "termAccession";
		if("PersonRole_termAccession".equalsIgnoreCase(fieldName)) return "termAccession";
		if("definition".equalsIgnoreCase(fieldName)) return "definition";
		if("PersonRole_definition".equalsIgnoreCase(fieldName)) return "definition";
		if("ontology_id".equalsIgnoreCase(fieldName)) return "ontology";
		if("PersonRole_ontology_id".equalsIgnoreCase(fieldName)) return "ontology";
		if("ontology_Identifier".equalsIgnoreCase(fieldName)) return "ontology.Identifier";	
		if("PersonRole_ontology_Identifier".equalsIgnoreCase(fieldName)) return "ontology.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.auth.PersonRole> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.auth.PersonRole>(size);
	}			

	@Override
	public org.molgenis.omx.auth.PersonRole create()
	{
		return new org.molgenis.omx.auth.PersonRole();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.auth.PersonRole> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'ontology' to ontology.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> ontologyRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.auth.PersonRole object: entities)
		{
			//create xref/mref rule filtering Ontology on the label Identifier
			if(object.getOntology_Id() == null && object.getOntology_Identifier() != null)
			{
				Object label = object.getOntology_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!ontologyRules.containsKey(label))
					{
						ontologyRules.put(""+label, xrefFilter);
						ontologyRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'ontology' to ontology.id using Identifier)
		final java.util.Map<String,Integer> ontology_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(ontologyRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.Ontology> ontologyList = null;
			try
			{
				ontologyList = getDatabase().find(org.molgenis.omx.observ.target.Ontology.class, ontologyRules.values().toArray(new org.molgenis.framework.db.QueryRule[ontologyRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.Ontology xref :  ontologyList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				ontology_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.auth.PersonRole object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getOntology_Id() == null )
			{
					String key = "";
					if(object.getOntology_Identifier() != null)
						key += 	object.getOntology_Identifier();
					
					if(!"".equals(key) && ontology_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("ontology_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setOntology_Id(ontology_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "personRole.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("ontology".equalsIgnoreCase(fieldName) || "ontologyTerm.ontology".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("termAccession".equalsIgnoreCase(fieldName) || "ontologyTerm.termAccession".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("definition".equalsIgnoreCase(fieldName) || "ontologyTerm.definition".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.auth.PersonRole> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.auth.PersonRole> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
