
/* File:        org.molgenis.omx/model/DataSet.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ;

/**
 * DataSet: Container for one or more observations that are measured
				using the same protocol and by the same performer(s). The data set
				may be a file (having the same identifier) but in most cases it is a
				data table consisting of rows (Observation).
				This entity replaces ProtocolApplication.
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "DataSet"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.observ.db.DataSetEntityListener.class})
public class DataSet extends org.molgenis.omx.observ.Characteristic 
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String PROTOCOLUSED = "ProtocolUsed";
	public final static String PROTOCOLUSED_IDENTIFIER = "ProtocolUsed_Identifier";
	public final static String STARTTIME = "startTime";
	public final static String ENDTIME = "endTime";
	public final static String ACTIVE = "active";
	public final static String ID = "id";
	
	//static methods
	/**
	 * Shorthand for db.query(DataSet.class).
	 */
	public static org.molgenis.framework.db.Query<? extends DataSet> query(org.molgenis.framework.db.Database db)
	{
		return db.query(DataSet.class);
	}
	
	/**
	 * Shorthand for db.find(DataSet.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends DataSet> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(DataSet.class, rules);
	}	
	
	/**
	 * 
	 */
	public static DataSet findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<DataSet> q = db.query(DataSet.class);
		q = q.eq(DataSet.ID, id);
		java.util.List<DataSet> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static DataSet findByIdentifier(org.molgenis.framework.db.Database db, String identifier) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<DataSet> q = db.query(DataSet.class);
		q = q.eq(DataSet.IDENTIFIER, identifier);
		java.util.List<DataSet> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//Reference to the protocol that is being used (if available)[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ProtocolUsed", nullable=false)   	
	
				

	@javax.validation.constraints.NotNull
	private org.molgenis.omx.observ.Protocol protocolUsed = null;
	@javax.persistence.Transient
	private Integer protocolUsed_id = null;	
	@javax.persistence.Transient
	private String protocolUsed_Identifier = null;						

	//time when the protocol started.[type=datetime]
    @javax.persistence.Temporal(javax.persistence.TemporalType.TIMESTAMP)
	@javax.persistence.Column(name="startTime", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="startTime")
	
				

	@javax.validation.constraints.NotNull
	private java.util.Date startTime =  new java.sql.Date(new java.util.Date().getTime());

	//(Optional) time when the protocol ended.[type=datetime]
    @javax.persistence.Temporal(javax.persistence.TemporalType.TIMESTAMP)
	@javax.persistence.Column(name="endTime")
	@javax.xml.bind.annotation.XmlElement(name="endTime")
	
				

	private java.util.Date endTime =  new java.sql.Date(new java.util.Date().getTime());

	//whether this data set is considered active/inactive[type=bool]
	@javax.persistence.Column(name="active", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="active")
	
				

	@javax.validation.constraints.NotNull
	private Boolean active =  true;

	//automatically generated internal id, only for internal use.[type=int]
	

	//constructors
	public DataSet()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	/** copy constructor */
	public DataSet(DataSet copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the Reference to the protocol that is being used (if available).
	 * @return protocolUsed.
	 */
	public org.molgenis.omx.observ.Protocol getProtocolUsed()
	{
		return this.protocolUsed;
	}
	
	@Deprecated
	public org.molgenis.omx.observ.Protocol getProtocolUsed(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Reference to the protocol that is being used (if available).
	 * @param protocolUsed
	 */
	public void setProtocolUsed( org.molgenis.omx.observ.Protocol protocolUsed)
	{
		
		this.protocolUsed = protocolUsed;
	}

	
	
	/**
	 * Set foreign key for field protocolUsed.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setProtocolUsed_Id(Integer protocolUsed_id)
	{
		this.protocolUsed_id = protocolUsed_id;
	}	

	public void setProtocolUsed(Integer protocolUsed_id)
	{
		this.protocolUsed_id = protocolUsed_id;
	}
	
	public Integer getProtocolUsed_Id()
	{
		
		if(protocolUsed != null) 
		{
			return protocolUsed.getId();
		}
		else
		{
			return protocolUsed_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference ProtocolUsed to Protocol.Id.
	 */
	public String getProtocolUsed_Identifier()
	{		
		//FIXME should we auto-load based on getProtocolUsed()?	
		if(protocolUsed != null) {
			return protocolUsed.getIdentifier();
		} else {
			return protocolUsed_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference ProtocolUsed to <a href="Protocol.html#Id">Protocol.Id</a>.
	 * Implies setProtocolUsed(null) until save
	 */
	public void setProtocolUsed_Identifier(String protocolUsed_Identifier)
	{
		this.protocolUsed_Identifier = protocolUsed_Identifier;
	}		
	 
	

	/**
	 * Get the time when the protocol started..
	 * @return startTime.
	 */
	public java.util.Date getStartTime()
	{
		return this.startTime;
	}
	
	@Deprecated
	public java.util.Date getStartTime(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the time when the protocol started..
	 * @param startTime
	 */
	public void setStartTime( java.util.Date startTime)
	{
		
		this.startTime = startTime;
	}

	

	/**
	 * Get the (Optional) time when the protocol ended..
	 * @return endTime.
	 */
	public java.util.Date getEndTime()
	{
		return this.endTime;
	}
	
	@Deprecated
	public java.util.Date getEndTime(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the (Optional) time when the protocol ended..
	 * @param endTime
	 */
	public void setEndTime( java.util.Date endTime)
	{
		
		this.endTime = endTime;
	}

	

	/**
	 * Get the whether this data set is considered active/inactive.
	 * @return active.
	 */
	public Boolean getActive()
	{
		return this.active;
	}
	
	@Deprecated
	public Boolean getActive(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the whether this data set is considered active/inactive.
	 * @param active
	 */
	public void setActive( Boolean active)
	{
		
		this.active = active;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();
		if (name.equals("description"))
			return getDescription();
		if (name.equals("protocolused"))
			return getProtocolUsed();
		if(name.equals("protocolused_id"))
			return getProtocolUsed_Id();
		if(name.equals("protocolused_identifier"))
			return getProtocolUsed_Identifier();
		if (name.equals("starttime"))
			return getStartTime();
		if (name.equals("endtime"))
			return getEndTime();
		if (name.equals("active"))
			return getActive();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getIdentifier() == null) throw new org.molgenis.framework.db.DatabaseException("required field identifier is null");
		if(this.getName() == null) throw new org.molgenis.framework.db.DatabaseException("required field name is null");
		if(this.get__Type() == null) throw new org.molgenis.framework.db.DatabaseException("required field __Type is null");
		if(this.getProtocolUsed() == null) throw new org.molgenis.framework.db.DatabaseException("required field protocolUsed is null");
		if(this.getStartTime() == null) throw new org.molgenis.framework.db.DatabaseException("required field startTime is null");
		if(this.getActive() == null) throw new org.molgenis.framework.db.DatabaseException("required field active is null");
	}
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("dataset_id") != null) this.setId(entity.getInt("dataset_id"));
		else if( entity.getInt("DataSet_id") != null) this.setId(entity.getInt("DataSet_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("dataset_identifier") != null) this.setIdentifier(entity.getString("dataset_identifier"));
		else if( entity.getString("DataSet_Identifier") != null) this.setIdentifier(entity.getString("DataSet_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("dataset_name") != null) this.setName(entity.getString("dataset_name"));
		else if( entity.getString("DataSet_Name") != null) this.setName(entity.getString("DataSet_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("dataset___type") != null) this.set__Type(entity.getString("dataset___type"));
		else if( entity.getString("DataSet___Type") != null) this.set__Type(entity.getString("DataSet___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("dataset_description") != null) this.setDescription(entity.getString("dataset_description"));
		else if( entity.getString("DataSet_description") != null) this.setDescription(entity.getString("DataSet_description"));
		//set ProtocolUsed
		// query formal name, else lowercase name
		if(entity.getInt("ProtocolUsed_id") != null) this.setProtocolUsed(entity.getInt("ProtocolUsed_id"));
		else if(entity.getInt("protocolused_id") != null) this.setProtocolUsed(entity.getInt("protocolused_id"));
		else if(strict) this.setProtocolUsed(entity.getInt("ProtocolUsed_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("DataSet_ProtocolUsed_id") != null) this.setProtocolUsed(entity.getInt("DataSet_ProtocolUsed_id"));
		else if( entity.getInt("dataset_protocolused_id") != null) this.setProtocolUsed(entity.getInt("dataset_protocolused_id"));
		//alias of xref
		if( entity.get("ProtocolUsed") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("ProtocolUsed").toString())) {
				org.molgenis.omx.observ.Protocol instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("ProtocolUsed"), org.molgenis.omx.observ.Protocol.class);
				this.setProtocolUsed(instance);				
			} else {
				this.setProtocolUsed_Id(entity.getInt("ProtocolUsed")); 
			}
		}
		else if( entity.get("protocolused") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("protocolused").toString())) {
				org.molgenis.omx.observ.Protocol instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("protocolused"), org.molgenis.omx.observ.Protocol.class);
				this.setProtocolUsed(instance);				
			} else {
				this.setProtocolUsed_Id(entity.getInt("ProtocolUsed"));
			}
		}
		if( entity.get("DataSet_ProtocolUsed") != null)
			this.setProtocolUsed_Id(entity.getInt("DataSet_ProtocolUsed"));			
		else if( entity.get("dataset_protocolused") != null)
			this.setProtocolUsed_Id(entity.getInt("dataset_protocolused"));
			
		if( entity.get("DataSet.ProtocolUsed") != null) 
			this.setProtocolUsed((org.molgenis.omx.observ.Protocol)entity.get("DataSet.ProtocolUsed_id"));
		else if( entity.get("dataset.protocolused") != null) 
			this.setProtocolUsed((org.molgenis.omx.observ.Protocol)entity.get("dataset.protocolused_id"));	
		//set label for field ProtocolUsed
		if(entity.get("ProtocolUsed_Identifier") != null) this.setProtocolUsed_Identifier(entity.getString("ProtocolUsed_Identifier"));
		else if(entity.get("protocolused_identifier") != null) this.setProtocolUsed_Identifier(entity.getString("protocolused_identifier"));
		else if(strict) this.setProtocolUsed_Identifier(entity.getString("ProtocolUsed_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("DataSet_ProtocolUsed_Identifier") != null ) this.setProtocolUsed_Identifier(entity.getString("DataSet_ProtocolUsed_Identifier"));		
		else if( entity.get("dataset_protocolused_identifier") != null ) this.setProtocolUsed_Identifier(entity.getString("dataset_protocolused_identifier"));
		//set StartTime
		// query formal name, else lowercase name
		if(entity.getTimestamp("starttime") != null) this.setStartTime(entity.getTimestamp("starttime"));
		else if(entity.getTimestamp("startTime") != null) this.setStartTime(entity.getTimestamp("startTime"));
		else if(strict) this.setStartTime(entity.getTimestamp("starttime")); // setting null is not an option due to function overloading
		if( entity.getTimestamp("dataset_starttime") != null) this.setStartTime(entity.getTimestamp("dataset_starttime"));
		else if( entity.getTimestamp("DataSet_startTime") != null) this.setStartTime(entity.getTimestamp("DataSet_startTime"));
		//set EndTime
		// query formal name, else lowercase name
		if(entity.getTimestamp("endtime") != null) this.setEndTime(entity.getTimestamp("endtime"));
		else if(entity.getTimestamp("endTime") != null) this.setEndTime(entity.getTimestamp("endTime"));
		else if(strict) this.setEndTime(entity.getTimestamp("endtime")); // setting null is not an option due to function overloading
		if( entity.getTimestamp("dataset_endtime") != null) this.setEndTime(entity.getTimestamp("dataset_endtime"));
		else if( entity.getTimestamp("DataSet_endTime") != null) this.setEndTime(entity.getTimestamp("DataSet_endTime"));
		//set Active
		// query formal name, else lowercase name
		if(entity.getBoolean("active") != null) this.setActive(entity.getBoolean("active"));
		else if(entity.getBoolean("active") != null) this.setActive(entity.getBoolean("active"));
		else if(strict) this.setActive(entity.getBoolean("active")); // setting null is not an option due to function overloading
		if( entity.getBoolean("dataset_active") != null) this.setActive(entity.getBoolean("dataset_active"));
		else if( entity.getBoolean("DataSet_active") != null) this.setActive(entity.getBoolean("DataSet_active"));
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "DataSet(";
		result+= "id='" + getId()+"' ";	
		result+= "identifier='" + getIdentifier()+"' ";	
		result+= "name='" + getName()+"' ";	
		result+= "__Type='" + get__Type()+"' ";	
		result+= "description='" + getDescription()+"' ";	
		result+= " protocolUsed_id='" + getProtocolUsed_Id()+"' ";	
		result+= " protocolUsed_identifier='" + getProtocolUsed_Identifier()+"' ";
		result+= "startTime='" + (getStartTime() == null ? "" : new java.text.SimpleDateFormat("MMMM d, yyyy, HH:mm:ss", java.util.Locale.US).format(getStartTime()))+"' ";
		result+= "startTime='" + (getStartTime() == null ? "" : new java.text.SimpleDateFormat("MMMM d, yyyy", java.util.Locale.US).format(getStartTime()))+"' ";		
		result+= "endTime='" + (getEndTime() == null ? "" : new java.text.SimpleDateFormat("MMMM d, yyyy, HH:mm:ss", java.util.Locale.US).format(getEndTime()))+"' ";
		result+= "endTime='" + (getEndTime() == null ? "" : new java.text.SimpleDateFormat("MMMM d, yyyy", java.util.Locale.US).format(getEndTime()))+"' ";		
		result+= "active='" + getActive()+"'";	
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of DataSet.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Identifier");
		}
		{
			fields.add("Name");
		}
		{
			fields.add("__Type");
		}
		{
			fields.add("description");
		}
		{
			fields.add("ProtocolUsed_id");
		}
		fields.add("ProtocolUsed_Identifier");
		{
			fields.add("startTime");
		}
		{
			fields.add("endTime");
		}
		{
			fields.add("active");
		}
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "identifier" +sep
		+ "name" +sep
		+ "__Type" +sep
		+ "description" +sep
		+ "protocolUsed" +sep
		+ "startTime" +sep
		+ "endTime" +sep
		+ "active" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("protocolUsed")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdentifier();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = get__Type();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDescription();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getProtocolUsed();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getStartTime();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getEndTime();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getActive();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public DataSet create(org.molgenis.data.Entity entity) throws Exception
	{
		DataSet e = new DataSet();
		e.set(entity);
		return e;
	}
	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
}
