/* File:        org.molgenis.omx/model/Category.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 14, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class CategoryJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.observ.Category>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(CategoryJpaMapper.class);

	public CategoryJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Category.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", Category.observableFeature"
			+", Category.valueCode"
			+", Category.definition"
			+", Category.isMissing"
			//parent is SimpleTree(name='observableFeature')
			+", xref_observableFeature.Identifier AS observableFeature_Identifier"
			//parent is SimpleTree(name='definition')
			+", xref_definition.Identifier AS definition_Identifier"
			+" FROM Category "
			+" INNER JOIN Characteristic ON (Category.id = Characteristic.id)"

			
			//label for observableFeature=Identifier
//path==observableFeature. type==xref.
//path==observableFeature_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_observableFeature " 
			+" ON xref_observableFeature.id = Category.observableFeature"
			
			//label for definition=Identifier
//path==definition. type==xref.
//path==definition_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_definition " 
			+" ON xref_definition.id = Category.definition"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.observ.Category entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'observableFeature' is known in the databse
			if(entity.getObservableFeature() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getObservableFeature().getIdValue() == null)
					new org.molgenis.omx.observ.db.ObservableFeatureJpaMapper(getDatabase()).create(entity.getObservableFeature());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getObservableFeature()) && entity.getObservableFeature().getIdValue() != null)
					entity.setObservableFeature(getEntityManager().getReference(org.molgenis.omx.observ.ObservableFeature.class, entity.getObservableFeature().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getObservableFeature_Id() != null) {
					entity.setObservableFeature((org.molgenis.omx.observ.ObservableFeature)getEntityManager().find(org.molgenis.omx.observ.ObservableFeature.class, entity.getObservableFeature_Id()));
				}
			}
			//check if the object refered by 'definition' is known in the databse
			if(entity.getDefinition() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getDefinition().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.OntologyTermJpaMapper(getDatabase()).create(entity.getDefinition());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getDefinition()) && entity.getDefinition().getIdValue() != null)
					entity.setDefinition(getEntityManager().getReference(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getDefinition().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getDefinition_Id() != null) {
					entity.setDefinition((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getDefinition_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.observ.Category category) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				category = getEntityManager().getReference(org.molgenis.omx.observ.Category.class, category.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The category with id " + category.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(category);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.observ.Category category) throws org.molgenis.framework.db.DatabaseException {
		try {







			//7
			org.molgenis.omx.observ.ObservableFeature observableFeatureNew = category.getObservableFeature();

			if (observableFeatureNew == null) { //object is reference by xref		
                            if(category.getObservableFeature_Id() != null) {
                                category.setObservableFeature((org.molgenis.omx.observ.ObservableFeature)getEntityManager().find(org.molgenis.omx.observ.ObservableFeature.class, category.getObservableFeature_Id()));
                            }
			}



			//6
			org.molgenis.omx.observ.target.OntologyTerm definitionNew = category.getDefinition();

			if (definitionNew == null) { //object is reference by xref		
                            if(category.getDefinition_Id() != null) {
                                category.setDefinition((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, category.getDefinition_Id()));
                            }
			}

			if(!getEntityManager().contains(category)) {
				category = getEntityManager().merge(category);
			}
			


		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.observ.Category> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.observ.Category category : entities) 
			{
				create(category);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.observ.Category> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.observ.Category category : entities) 
			{
				edit(category);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.observ.Category> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.observ.Category category : entities) 
			{
				destroy(category);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Category_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Category_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("Category_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Category___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("Category_description".equalsIgnoreCase(fieldName)) return "description";
		if("observableFeature".equalsIgnoreCase(fieldName)) return "observableFeature";
		if("Category_observableFeature".equalsIgnoreCase(fieldName)) return "observableFeature";
		if("valueCode".equalsIgnoreCase(fieldName)) return "valueCode";
		if("Category_valueCode".equalsIgnoreCase(fieldName)) return "valueCode";
		if("definition".equalsIgnoreCase(fieldName)) return "definition";
		if("Category_definition".equalsIgnoreCase(fieldName)) return "definition";
		if("isMissing".equalsIgnoreCase(fieldName)) return "isMissing";
		if("Category_isMissing".equalsIgnoreCase(fieldName)) return "isMissing";
		if("observableFeature_id".equalsIgnoreCase(fieldName)) return "observableFeature";
		if("Category_observableFeature_id".equalsIgnoreCase(fieldName)) return "observableFeature";
		if("observableFeature_Identifier".equalsIgnoreCase(fieldName)) return "observableFeature.Identifier";	
		if("Category_observableFeature_Identifier".equalsIgnoreCase(fieldName)) return "observableFeature.Identifier";
		if("definition_id".equalsIgnoreCase(fieldName)) return "definition";
		if("Category_definition_id".equalsIgnoreCase(fieldName)) return "definition";
		if("definition_Identifier".equalsIgnoreCase(fieldName)) return "definition.Identifier";	
		if("Category_definition_Identifier".equalsIgnoreCase(fieldName)) return "definition.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.observ.Category> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.observ.Category>(size);
	}			

	@Override
	public org.molgenis.omx.observ.Category create()
	{
		return new org.molgenis.omx.observ.Category();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.observ.Category> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'observableFeature' to observableFeature.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> observableFeatureRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'definition' to ontologyTerm.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> definitionRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.observ.Category object: entities)
		{
			//create xref/mref rule filtering ObservableFeature on the label Identifier
			if(object.getObservableFeature_Id() == null && object.getObservableFeature_Identifier() != null)
			{
				Object label = object.getObservableFeature_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!observableFeatureRules.containsKey(label))
					{
						observableFeatureRules.put(""+label, xrefFilter);
						observableFeatureRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering OntologyTerm on the label Identifier
			if(object.getDefinition_Id() == null && object.getDefinition_Identifier() != null)
			{
				Object label = object.getDefinition_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!definitionRules.containsKey(label))
					{
						definitionRules.put(""+label, xrefFilter);
						definitionRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'observableFeature' to observableFeature.id using Identifier)
		final java.util.Map<String,Integer> observableFeature_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(observableFeatureRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.ObservableFeature> observableFeatureList = null;
			try
			{
				observableFeatureList = getDatabase().find(org.molgenis.omx.observ.ObservableFeature.class, observableFeatureRules.values().toArray(new org.molgenis.framework.db.QueryRule[observableFeatureRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.ObservableFeature xref :  observableFeatureList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				observableFeature_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'definition' to ontologyTerm.id using Identifier)
		final java.util.Map<String,Integer> definition_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(definitionRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.OntologyTerm> definitionList = null;
			try
			{
				definitionList = getDatabase().find(org.molgenis.omx.observ.target.OntologyTerm.class, definitionRules.values().toArray(new org.molgenis.framework.db.QueryRule[definitionRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.OntologyTerm xref :  definitionList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				definition_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.observ.Category object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getObservableFeature_Id() == null )
			{
					String key = "";
					if(object.getObservableFeature_Identifier() != null)
						key += 	object.getObservableFeature_Identifier();
					
					if(!"".equals(key) && observableFeature_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("observableFeature_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setObservableFeature_Id(observableFeature_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getDefinition_Id() == null )
			{
					String key = "";
					if(object.getDefinition_Identifier() != null)
						key += 	object.getDefinition_Identifier();
					
					if(!"".equals(key) && definition_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("definition_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setDefinition_Id(definition_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "category.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("observableFeature".equalsIgnoreCase(fieldName) || "category.observableFeature".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("valueCode".equalsIgnoreCase(fieldName) || "category.valueCode".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("definition".equalsIgnoreCase(fieldName) || "category.definition".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("isMissing".equalsIgnoreCase(fieldName) || "category.isMissing".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.BoolField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.observ.Category> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.observ.Category> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
