/* File:        org.molgenis.omx/model/DataSet.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 14, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class DataSetJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.observ.DataSet>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(DataSetJpaMapper.class);

	public DataSetJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT DataSet.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", DataSet.ProtocolUsed"
			+", DataSet.startTime"
			+", DataSet.endTime"
			+", DataSet.active"
			//parent is SimpleTree(name='ProtocolUsed')
			+", xref_ProtocolUsed.Identifier AS ProtocolUsed_Identifier"
			+" FROM DataSet "
			+" INNER JOIN Characteristic ON (DataSet.id = Characteristic.id)"

			
			//label for ProtocolUsed=Identifier
//path==ProtocolUsed. type==xref.
//path==ProtocolUsed_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_ProtocolUsed " 
			+" ON xref_ProtocolUsed.id = DataSet.ProtocolUsed"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.observ.DataSet entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'ProtocolUsed' is known in the databse
			if(entity.getProtocolUsed() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getProtocolUsed().getIdValue() == null)
					new org.molgenis.omx.observ.db.ProtocolJpaMapper(getDatabase()).create(entity.getProtocolUsed());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getProtocolUsed()) && entity.getProtocolUsed().getIdValue() != null)
					entity.setProtocolUsed(getEntityManager().getReference(org.molgenis.omx.observ.Protocol.class, entity.getProtocolUsed().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getProtocolUsed_Id() != null) {
					entity.setProtocolUsed((org.molgenis.omx.observ.Protocol)getEntityManager().find(org.molgenis.omx.observ.Protocol.class, entity.getProtocolUsed_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.observ.DataSet dataSet) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				dataSet = getEntityManager().getReference(org.molgenis.omx.observ.DataSet.class, dataSet.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The dataSet with id " + dataSet.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(dataSet);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.observ.DataSet dataSet) throws org.molgenis.framework.db.DatabaseException {
		try {







			//6
			org.molgenis.omx.observ.Protocol protocolUsedNew = dataSet.getProtocolUsed();

			if (protocolUsedNew == null) { //object is reference by xref		
                            if(dataSet.getProtocolUsed_Id() != null) {
                                dataSet.setProtocolUsed((org.molgenis.omx.observ.Protocol)getEntityManager().find(org.molgenis.omx.observ.Protocol.class, dataSet.getProtocolUsed_Id()));
                            }
			}



			if(!getEntityManager().contains(dataSet)) {
				dataSet = getEntityManager().merge(dataSet);
			}
			

		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.observ.DataSet> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.observ.DataSet dataSet : entities) 
			{
				create(dataSet);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.observ.DataSet> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.observ.DataSet dataSet : entities) 
			{
				edit(dataSet);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.observ.DataSet> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.observ.DataSet dataSet : entities) 
			{
				destroy(dataSet);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("DataSet_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("DataSet_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("DataSet_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("DataSet___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("DataSet_description".equalsIgnoreCase(fieldName)) return "description";
		if("ProtocolUsed".equalsIgnoreCase(fieldName)) return "ProtocolUsed";
		if("DataSet_ProtocolUsed".equalsIgnoreCase(fieldName)) return "ProtocolUsed";
		if("startTime".equalsIgnoreCase(fieldName)) return "startTime";
		if("DataSet_startTime".equalsIgnoreCase(fieldName)) return "startTime";
		if("endTime".equalsIgnoreCase(fieldName)) return "endTime";
		if("DataSet_endTime".equalsIgnoreCase(fieldName)) return "endTime";
		if("active".equalsIgnoreCase(fieldName)) return "active";
		if("DataSet_active".equalsIgnoreCase(fieldName)) return "active";
		if("ProtocolUsed_id".equalsIgnoreCase(fieldName)) return "ProtocolUsed";
		if("DataSet_ProtocolUsed_id".equalsIgnoreCase(fieldName)) return "ProtocolUsed";
		if("ProtocolUsed_Identifier".equalsIgnoreCase(fieldName)) return "ProtocolUsed.Identifier";	
		if("DataSet_ProtocolUsed_Identifier".equalsIgnoreCase(fieldName)) return "ProtocolUsed.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.observ.DataSet> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.observ.DataSet>(size);
	}			

	@Override
	public org.molgenis.omx.observ.DataSet create()
	{
		return new org.molgenis.omx.observ.DataSet();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.observ.DataSet> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'protocolUsed' to protocol.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> protocolUsedRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.observ.DataSet object: entities)
		{
			//create xref/mref rule filtering Protocol on the label Identifier
			if(object.getProtocolUsed_Id() == null && object.getProtocolUsed_Identifier() != null)
			{
				Object label = object.getProtocolUsed_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!protocolUsedRules.containsKey(label))
					{
						protocolUsedRules.put(""+label, xrefFilter);
						protocolUsedRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'protocolUsed' to protocol.id using Identifier)
		final java.util.Map<String,Integer> protocolUsed_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(protocolUsedRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.Protocol> protocolUsedList = null;
			try
			{
				protocolUsedList = getDatabase().find(org.molgenis.omx.observ.Protocol.class, protocolUsedRules.values().toArray(new org.molgenis.framework.db.QueryRule[protocolUsedRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.Protocol xref :  protocolUsedList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				protocolUsed_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.observ.DataSet object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getProtocolUsed_Id() == null )
			{
					String key = "";
					if(object.getProtocolUsed_Identifier() != null)
						key += 	object.getProtocolUsed_Identifier();
					
					if(!"".equals(key) && protocolUsed_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("ProtocolUsed_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setProtocolUsed_Id(protocolUsed_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "dataSet.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("protocolUsed".equalsIgnoreCase(fieldName) || "dataSet.protocolUsed".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("startTime".equalsIgnoreCase(fieldName) || "dataSet.startTime".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.DatetimeField();
			if("endTime".equalsIgnoreCase(fieldName) || "dataSet.endTime".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.DatetimeField();
			if("active".equalsIgnoreCase(fieldName) || "dataSet.active".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.BoolField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.observ.DataSet> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.observ.DataSet> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
