
/* File:        org.molgenis.omx/model/ObservableFeature.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 14, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.omx.observ.ObservableFeature;


/**
 * Reads ObservableFeature from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class ObservableFeatureEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(ObservableFeatureEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'unit' (maps ontologyTerm.Identifier -> ontologyTerm.id)			
	final Map<String,Integer> unitKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'definitions' (maps ontologyTerm.Identifier -> ontologyTerm.id)			
	final Map<String,Integer> definitionsKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports ObservableFeature from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<ObservableFeature> observableFeaturesMissingRefs = new ArrayList<ObservableFeature>();
	
		//cache for objects to be imported from file (in batch)
		final List<ObservableFeature> observableFeatureList = new ArrayList<ObservableFeature>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			ObservableFeature object = new ObservableFeature();
			object.set(entity, false);				
			observableFeatureList.add(object);		
			
			//add to db when batch size is reached
			if(observableFeatureList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				observableFeaturesMissingRefs.addAll(resolveForeignKeys(db, observableFeatureList));
				observableFeatureList.removeAll(observableFeaturesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(observableFeatureList,dbAction, "Identifier");
				
				//clear for next batch						
				observableFeatureList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!observableFeatureList.isEmpty())
		{
			total.set(total.get() + observableFeatureList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			observableFeaturesMissingRefs.addAll(resolveForeignKeys(db, observableFeatureList));
			observableFeatureList.removeAll(observableFeaturesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(observableFeatureList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<ObservableFeature> observableFeatures = new ArrayList<ObservableFeature>(observableFeaturesMissingRefs);

		int iterationCount = 0;

		do
		{
			observableFeaturesMissingRefs = resolveForeignKeys(db, observableFeaturesMissingRefs);
			
			LinkedHashSet<ObservableFeature> differenceSet = new LinkedHashSet<ObservableFeature>();
			Sets.symmetricDifference(new LinkedHashSet<ObservableFeature>(observableFeatures), new LinkedHashSet<ObservableFeature>(observableFeaturesMissingRefs)).copyInto(differenceSet);
			List<ObservableFeature> resolvableobservableFeatures = new ArrayList<ObservableFeature>(differenceSet);
			
			observableFeatures.removeAll(resolvableobservableFeatures);
			
			db.update(resolvableobservableFeatures,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(ObservableFeature blaat : observableFeaturesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'observableFeature' entity failed:"
								+ "This is probably caused by a(n) 'observableFeature' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (observableFeaturesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " observableFeature from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param observableFeatureList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<ObservableFeature> resolveForeignKeys(Database db, List<ObservableFeature> observableFeatureList) throws Exception
	{
		//keep a list of ObservableFeature instances that miss a reference which might be resolvable later
		List<ObservableFeature> observableFeaturesMissingRefs = new ArrayList<ObservableFeature>();
	
		//resolve xref 'unit' from ontologyTerm.Identifier -> ontologyTerm.id
		for(ObservableFeature o: observableFeatureList) 
		{
			if(o.getUnit_Identifier() != null) 
				unitKeymap.put(o.getUnit_Identifier(), null);
		}
		
		if(unitKeymap.size() > 0) 
		{
			List<OntologyTerm> unitList = db.query(OntologyTerm.class).in("Identifier",new ArrayList<Object>(unitKeymap.keySet())).find();
			for(OntologyTerm xref :  unitList)
			{
				unitKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'definitions' from ontologyTerm.Identifier -> ontologyTerm.id
		for(ObservableFeature o: observableFeatureList) for(String xref_label: o.getDefinitions_Identifier())
		{
			if(xref_label != null) 
				definitionsKeymap.put(xref_label.trim(), null);
		}
		
		if(definitionsKeymap.size() > 0) 
		{
			List<OntologyTerm> definitionsList = db.query(OntologyTerm.class).in("Identifier",new ArrayList<Object>(definitionsKeymap.keySet())).find();
			for(OntologyTerm xref :  definitionsList)
			{
				definitionsKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(ObservableFeature o:  observableFeatureList)
		{
			while(true){
				//update xref unit
				if(o.getUnit_Identifier() != null) 
				{
					String key = o.getUnit_Identifier();
					if(unitKeymap.get(key) == null)
					{
						throw new Exception("Import of 'ObservableFeature' objects failed: cannot find OntologyTerm for unit_Identifier='"+o.getUnit_Identifier()+"'");
					}
					o.setUnit_Id(unitKeymap.get(key));
				}
				//update mref definitions
				if(o.getDefinitions_Identifier() != null) 
				{
					List<Integer> mrefs = new ArrayList<Integer>();
					boolean breakToNextObservableFeature = false;

					int listSize = 0;
					if(o.getDefinitions_Identifier() != null) listSize = Math.max(o.getDefinitions_Identifier().size(), listSize);
					for(int i = 0; i < listSize; i++)
					{
						String key = o.getDefinitions_Identifier().get(i);
							key = key.trim();				
						if(definitionsKeymap.get(key) == null){
							logger.error("Import of 'ObservableFeature' objects failed: "+o);
							throw new Exception("Import of 'ObservableFeature' objects failed:" 
							+"cannot find definitions_Identifier='"+(o.getDefinitions_Identifier() != null && i < o.getDefinitions_Identifier().size() ? o.getDefinitions_Identifier().get(i) : "null")+"'");
						}
						mrefs.add(definitionsKeymap.get(key));
					}
					if(breakToNextObservableFeature){
						break;
					}
					o.setDefinitions_Id(mrefs);
				}
				break;
			}
		}
		
		unitKeymap.clear();
		definitionsKeymap.clear();
		
		return observableFeaturesMissingRefs;
	}
}

