
/* File:        org.molgenis.omx/model/ObservableFeature_definitions.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 14, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.ObservableFeature_Definitions;


/**
 * Reads ObservableFeature_Definitions from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class ObservableFeature_DefinitionsEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(ObservableFeature_DefinitionsEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'definitions' (maps ontologyTerm.Identifier -> ontologyTerm.id)			
	final Map<String,Integer> definitionsKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'observableFeature' (maps observableFeature.Identifier -> observableFeature.id)			
	final Map<String,Integer> observableFeatureKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports ObservableFeature_Definitions from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<ObservableFeature_Definitions> observableFeature_definitionssMissingRefs = new ArrayList<ObservableFeature_Definitions>();
	
		//cache for objects to be imported from file (in batch)
		final List<ObservableFeature_Definitions> observableFeature_definitionsList = new ArrayList<ObservableFeature_Definitions>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			ObservableFeature_Definitions object = new ObservableFeature_Definitions();
			object.set(entity, false);				
			observableFeature_definitionsList.add(object);		
			
			//add to db when batch size is reached
			if(observableFeature_definitionsList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				observableFeature_definitionssMissingRefs.addAll(resolveForeignKeys(db, observableFeature_definitionsList));
				observableFeature_definitionsList.removeAll(observableFeature_definitionssMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'definitions,ObservableFeature' defined in xref_label
				db.update(observableFeature_definitionsList,dbAction, "definitions", "ObservableFeature");
				
				//clear for next batch						
				observableFeature_definitionsList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!observableFeature_definitionsList.isEmpty())
		{
			total.set(total.get() + observableFeature_definitionsList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			observableFeature_definitionssMissingRefs.addAll(resolveForeignKeys(db, observableFeature_definitionsList));
			observableFeature_definitionsList.removeAll(observableFeature_definitionssMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'definitions,ObservableFeature' defined in xref_label
			db.update(observableFeature_definitionsList,dbAction, "definitions", "ObservableFeature");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<ObservableFeature_Definitions> observableFeature_definitionss = new ArrayList<ObservableFeature_Definitions>(observableFeature_definitionssMissingRefs);

		int iterationCount = 0;

		do
		{
			observableFeature_definitionssMissingRefs = resolveForeignKeys(db, observableFeature_definitionssMissingRefs);
			
			LinkedHashSet<ObservableFeature_Definitions> differenceSet = new LinkedHashSet<ObservableFeature_Definitions>();
			Sets.symmetricDifference(new LinkedHashSet<ObservableFeature_Definitions>(observableFeature_definitionss), new LinkedHashSet<ObservableFeature_Definitions>(observableFeature_definitionssMissingRefs)).copyInto(differenceSet);
			List<ObservableFeature_Definitions> resolvableobservableFeature_definitionss = new ArrayList<ObservableFeature_Definitions>(differenceSet);
			
			observableFeature_definitionss.removeAll(resolvableobservableFeature_definitionss);
			
			db.update(resolvableobservableFeature_definitionss,dbAction, "definitions", "ObservableFeature");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(ObservableFeature_Definitions blaat : observableFeature_definitionssMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'observableFeature_definitions' entity failed:"
								+ "This is probably caused by a(n) 'observableFeature_definitions' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (observableFeature_definitionssMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " observableFeature_definitions from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param observableFeature_definitionsList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<ObservableFeature_Definitions> resolveForeignKeys(Database db, List<ObservableFeature_Definitions> observableFeature_definitionsList) throws Exception
	{
		//keep a list of ObservableFeature_definitions instances that miss a reference which might be resolvable later
		List<ObservableFeature_Definitions> observableFeature_definitionssMissingRefs = new ArrayList<ObservableFeature_Definitions>();
	
		//resolve xref 'definitions' from ontologyTerm.Identifier -> ontologyTerm.id
		for(ObservableFeature_Definitions o: observableFeature_definitionsList) 
		{
			if(o.getDefinitions_Identifier() != null) 
				definitionsKeymap.put(o.getDefinitions_Identifier(), null);
		}
		
		if(definitionsKeymap.size() > 0) 
		{
			List<OntologyTerm> definitionsList = db.query(OntologyTerm.class).in("Identifier",new ArrayList<Object>(definitionsKeymap.keySet())).find();
			for(OntologyTerm xref :  definitionsList)
			{
				definitionsKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'observableFeature' from observableFeature.Identifier -> observableFeature.id
		for(ObservableFeature_Definitions o: observableFeature_definitionsList) 
		{
			if(o.getObservableFeature_Identifier() != null) 
				observableFeatureKeymap.put(o.getObservableFeature_Identifier(), null);
		}
		
		if(observableFeatureKeymap.size() > 0) 
		{
			List<ObservableFeature> observableFeatureList = db.query(ObservableFeature.class).in("Identifier",new ArrayList<Object>(observableFeatureKeymap.keySet())).find();
			for(ObservableFeature xref :  observableFeatureList)
			{
				observableFeatureKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(ObservableFeature_Definitions o:  observableFeature_definitionsList)
		{
			while(true){
				//update xref definitions
				if(o.getDefinitions_Identifier() != null) 
				{
					String key = o.getDefinitions_Identifier();
					if(definitionsKeymap.get(key) == null)
					{
						throw new Exception("Import of 'ObservableFeature_definitions' objects failed: cannot find OntologyTerm for definitions_Identifier='"+o.getDefinitions_Identifier()+"'");
					}
					o.setDefinitions_Id(definitionsKeymap.get(key));
				}
				//update xref ObservableFeature
				if(o.getObservableFeature_Identifier() != null) 
				{
					String key = o.getObservableFeature_Identifier();
					if(observableFeatureKeymap.get(key) == null)
					{
						throw new Exception("Import of 'ObservableFeature_definitions' objects failed: cannot find ObservableFeature for observableFeature_Identifier='"+o.getObservableFeature_Identifier()+"'");
					}
					o.setObservableFeature_Id(observableFeatureKeymap.get(key));
				}
				break;
			}
		}
		
		definitionsKeymap.clear();
		observableFeatureKeymap.clear();
		
		return observableFeature_definitionssMissingRefs;
	}
}

