/* File:        org.molgenis.omx/model/Protocol.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 14, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class ProtocolJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.observ.Protocol>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(ProtocolJpaMapper.class);

	public ProtocolJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Protocol.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", Protocol.ProtocolType"
			+", Protocol.root"
			//parent is SimpleTree(name='ProtocolType')
			+", xref_ProtocolType.Identifier AS ProtocolType_Identifier"
			+" FROM Protocol "
			+" INNER JOIN Characteristic ON (Protocol.id = Characteristic.id)"

			
			//label for ProtocolType=Identifier
//path==ProtocolType. type==xref.
//path==ProtocolType_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_ProtocolType " 
			+" ON xref_ProtocolType.id = Protocol.ProtocolType"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.observ.Protocol entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'ProtocolType' is known in the databse
			if(entity.getProtocolType() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getProtocolType().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.OntologyTermJpaMapper(getDatabase()).create(entity.getProtocolType());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getProtocolType()) && entity.getProtocolType().getIdValue() != null)
					entity.setProtocolType(getEntityManager().getReference(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getProtocolType().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getProtocolType_Id() != null) {
					entity.setProtocolType((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getProtocolType_Id()));
				}
			}
	    java.util.List<org.molgenis.omx.observ.Protocol> subprotocolsList = entity.getSubprotocols();
	    java.util.List<Integer> subprotocolsIds = entity.getSubprotocols_Id();
	    for(Integer subprotocolsId : subprotocolsIds) {
		org.molgenis.omx.observ.Protocol protocol = getEntityManager().getReference(org.molgenis.omx.observ.Protocol.class, subprotocolsId);
		if(!subprotocolsList.contains(protocol))
		    subprotocolsList.add(protocol);
	    }
	    entity.setSubprotocols(subprotocolsList);
	    java.util.List<org.molgenis.omx.observ.ObservableFeature> featuresList = entity.getFeatures();
	    java.util.List<Integer> featuresIds = entity.getFeatures_Id();
	    for(Integer featuresId : featuresIds) {
		org.molgenis.omx.observ.ObservableFeature observableFeature = getEntityManager().getReference(org.molgenis.omx.observ.ObservableFeature.class, featuresId);
		if(!featuresList.contains(observableFeature))
		    featuresList.add(observableFeature);
	    }
	    entity.setFeatures(featuresList);
	    java.util.List<org.molgenis.omx.observ.ObservableFeature> requiredFeaturesList = entity.getRequiredFeatures();
	    java.util.List<Integer> requiredFeaturesIds = entity.getRequiredFeatures_Id();
	    for(Integer requiredFeaturesId : requiredFeaturesIds) {
		org.molgenis.omx.observ.ObservableFeature observableFeature = getEntityManager().getReference(org.molgenis.omx.observ.ObservableFeature.class, requiredFeaturesId);
		if(!requiredFeaturesList.contains(observableFeature))
		    requiredFeaturesList.add(observableFeature);
	    }
	    entity.setRequiredFeatures(requiredFeaturesList);

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.observ.Protocol protocol) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				protocol = getEntityManager().getReference(org.molgenis.omx.observ.Protocol.class, protocol.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The protocol with id " + protocol.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(protocol);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.observ.Protocol protocol) throws org.molgenis.framework.db.DatabaseException {
		try {







			//6
			org.molgenis.omx.observ.target.OntologyTerm protocolTypeNew = protocol.getProtocolType();

			if (protocolTypeNew == null) { //object is reference by xref		
                            if(protocol.getProtocolType_Id() != null) {
                                protocol.setProtocolType((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, protocol.getProtocolType_Id()));
                            }
			}


			//6
			for(org.molgenis.omx.observ.Protocol m : protocol.getSubprotocols()) {
				if(m.getId() == null) {
					getEntityManager().persist(m);
				}
			}
			
			for(Integer id : protocol.getSubprotocols_Id()) {
				org.molgenis.omx.observ.Protocol mref = getEntityManager().find(org.molgenis.omx.observ.Protocol.class, id);
				if(!protocol.getSubprotocols().contains(mref)) {
					protocol.getSubprotocols().add(mref);
				}
			}    


			//7
			for(org.molgenis.omx.observ.ObservableFeature m : protocol.getFeatures()) {
				if(m.getId() == null) {
					getEntityManager().persist(m);
				}
			}
			
			for(Integer id : protocol.getFeatures_Id()) {
				org.molgenis.omx.observ.ObservableFeature mref = getEntityManager().find(org.molgenis.omx.observ.ObservableFeature.class, id);
				if(!protocol.getFeatures().contains(mref)) {
					protocol.getFeatures().add(mref);
				}
			}    


			//7
			for(org.molgenis.omx.observ.ObservableFeature m : protocol.getRequiredFeatures()) {
				if(m.getId() == null) {
					getEntityManager().persist(m);
				}
			}
			
			for(Integer id : protocol.getRequiredFeatures_Id()) {
				org.molgenis.omx.observ.ObservableFeature mref = getEntityManager().find(org.molgenis.omx.observ.ObservableFeature.class, id);
				if(!protocol.getRequiredFeatures().contains(mref)) {
					protocol.getRequiredFeatures().add(mref);
				}
			}    

			if(!getEntityManager().contains(protocol)) {
				protocol = getEntityManager().merge(protocol);
			}
			

		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.observ.Protocol> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.observ.Protocol protocol : entities) 
			{
				create(protocol);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.observ.Protocol> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.observ.Protocol protocol : entities) 
			{
				edit(protocol);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.observ.Protocol> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.observ.Protocol protocol : entities) 
			{
				destroy(protocol);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Protocol_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Protocol_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("Protocol_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Protocol___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("Protocol_description".equalsIgnoreCase(fieldName)) return "description";
		if("ProtocolType".equalsIgnoreCase(fieldName)) return "ProtocolType";
		if("Protocol_ProtocolType".equalsIgnoreCase(fieldName)) return "ProtocolType";
		if("root".equalsIgnoreCase(fieldName)) return "root";
		if("Protocol_root".equalsIgnoreCase(fieldName)) return "root";
		if("ProtocolType_id".equalsIgnoreCase(fieldName)) return "ProtocolType";
		if("Protocol_ProtocolType_id".equalsIgnoreCase(fieldName)) return "ProtocolType";
		if("ProtocolType_Identifier".equalsIgnoreCase(fieldName)) return "ProtocolType.Identifier";	
		if("Protocol_ProtocolType_Identifier".equalsIgnoreCase(fieldName)) return "ProtocolType.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.observ.Protocol> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.observ.Protocol>(size);
	}			

	@Override
	public org.molgenis.omx.observ.Protocol create()
	{
		return new org.molgenis.omx.observ.Protocol();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.observ.Protocol> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'protocolType' to ontologyTerm.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> protocolTypeRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'subprotocols' to protocol.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> subprotocolsRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'features' to observableFeature.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> featuresRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'requiredFeatures' to observableFeature.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> requiredFeaturesRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.observ.Protocol object: entities)
		{
			//create xref/mref rule filtering OntologyTerm on the label Identifier
			if(object.getProtocolType_Id() == null && object.getProtocolType_Identifier() != null)
			{
				Object label = object.getProtocolType_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!protocolTypeRules.containsKey(label))
					{
						protocolTypeRules.put(""+label, xrefFilter);
						protocolTypeRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering Protocol on the label Identifier
			if(object.getSubprotocols_Id().size() == 0 && object.getSubprotocols_Identifier().size() > 0)
			{
				for(Object label: object.getSubprotocols_Identifier())
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!subprotocolsRules.containsKey(label))
					{
						subprotocolsRules.put(""+label, xrefFilter);
						subprotocolsRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering ObservableFeature on the label Identifier
			if(object.getFeatures_Id().size() == 0 && object.getFeatures_Identifier().size() > 0)
			{
				for(Object label: object.getFeatures_Identifier())
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!featuresRules.containsKey(label))
					{
						featuresRules.put(""+label, xrefFilter);
						featuresRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering ObservableFeature on the label Identifier
			if(object.getRequiredFeatures_Id().size() == 0 && object.getRequiredFeatures_Identifier().size() > 0)
			{
				for(Object label: object.getRequiredFeatures_Identifier())
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!requiredFeaturesRules.containsKey(label))
					{
						requiredFeaturesRules.put(""+label, xrefFilter);
						requiredFeaturesRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'protocolType' to ontologyTerm.id using Identifier)
		final java.util.Map<String,Integer> protocolType_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(protocolTypeRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.OntologyTerm> protocolTypeList = null;
			try
			{
				protocolTypeList = getDatabase().find(org.molgenis.omx.observ.target.OntologyTerm.class, protocolTypeRules.values().toArray(new org.molgenis.framework.db.QueryRule[protocolTypeRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.OntologyTerm xref :  protocolTypeList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				protocolType_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'subprotocols' to protocol.id using Identifier)
		final java.util.Map<String,Integer> subprotocols_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(subprotocolsRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.Protocol> subprotocolsList = null;
			try
			{
				subprotocolsList = getDatabase().find(org.molgenis.omx.observ.Protocol.class, subprotocolsRules.values().toArray(new org.molgenis.framework.db.QueryRule[subprotocolsRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.Protocol xref :  subprotocolsList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				subprotocols_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'features' to observableFeature.id using Identifier)
		final java.util.Map<String,Integer> features_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(featuresRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.ObservableFeature> featuresList = null;
			try
			{
				featuresList = getDatabase().find(org.molgenis.omx.observ.ObservableFeature.class, featuresRules.values().toArray(new org.molgenis.framework.db.QueryRule[featuresRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.ObservableFeature xref :  featuresList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				features_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'requiredFeatures' to observableFeature.id using Identifier)
		final java.util.Map<String,Integer> requiredFeatures_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(requiredFeaturesRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.ObservableFeature> requiredFeaturesList = null;
			try
			{
				requiredFeaturesList = getDatabase().find(org.molgenis.omx.observ.ObservableFeature.class, requiredFeaturesRules.values().toArray(new org.molgenis.framework.db.QueryRule[requiredFeaturesRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.ObservableFeature xref :  requiredFeaturesList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				requiredFeatures_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.observ.Protocol object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getProtocolType_Id() == null )
			{
					String key = "";
					if(object.getProtocolType_Identifier() != null)
						key += 	object.getProtocolType_Identifier();
					
					if(!"".equals(key) && protocolType_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("ProtocolType_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setProtocolType_Id(protocolType_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getSubprotocols_Id() == null || object.getSubprotocols_Id().size() == 0)
			{
				java.util.List<Integer> idList = new java.util.ArrayList<Integer>();
				for(int j = 0; j < object.getSubprotocols_Identifier().size(); j++)
				{
					String key = "";
					if(object.getSubprotocols_Identifier().get(j) != null)
						key += 	object.getSubprotocols_Identifier().get(j);
					
					if(!"".equals(key) && subprotocols_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("subprotocols_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						idList.add(subprotocols_Labels_to_IdMap.get(key));
					}
				}
				object.setSubprotocols_Id(idList);
			}
			//update object using label fields Identifier
			if(object.getFeatures_Id() == null || object.getFeatures_Id().size() == 0)
			{
				java.util.List<Integer> idList = new java.util.ArrayList<Integer>();
				for(int j = 0; j < object.getFeatures_Identifier().size(); j++)
				{
					String key = "";
					if(object.getFeatures_Identifier().get(j) != null)
						key += 	object.getFeatures_Identifier().get(j);
					
					if(!"".equals(key) && features_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Features_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						idList.add(features_Labels_to_IdMap.get(key));
					}
				}
				object.setFeatures_Id(idList);
			}
			//update object using label fields Identifier
			if(object.getRequiredFeatures_Id() == null || object.getRequiredFeatures_Id().size() == 0)
			{
				java.util.List<Integer> idList = new java.util.ArrayList<Integer>();
				for(int j = 0; j < object.getRequiredFeatures_Identifier().size(); j++)
				{
					String key = "";
					if(object.getRequiredFeatures_Identifier().get(j) != null)
						key += 	object.getRequiredFeatures_Identifier().get(j);
					
					if(!"".equals(key) && requiredFeatures_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("RequiredFeatures_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						idList.add(requiredFeatures_Labels_to_IdMap.get(key));
					}
				}
				object.setRequiredFeatures_Id(idList);
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "protocol.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("protocolType".equalsIgnoreCase(fieldName) || "protocol.protocolType".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("root".equalsIgnoreCase(fieldName) || "protocol.root".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.BoolField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.observ.Protocol> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.observ.Protocol> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
