
/* File:        org.molgenis.omx/model/Panel.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 14, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.target.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.omx.observ.target.Species;
import org.molgenis.omx.observ.target.Individual;
import org.molgenis.omx.observ.target.Panel;


/**
 * Reads Panel from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class PanelEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(PanelEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'panelType' (maps ontologyTerm.Identifier -> ontologyTerm.id)			
	final Map<String,Integer> panelTypeKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'species' (maps species.Identifier -> species.id)			
	final Map<String,Integer> speciesKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'individuals' (maps individual.Identifier -> individual.id)			
	final Map<String,Integer> individualsKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Panel from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Panel> panelsMissingRefs = new ArrayList<Panel>();
	
		//cache for objects to be imported from file (in batch)
		final List<Panel> panelList = new ArrayList<Panel>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Panel object = new Panel();
			object.set(entity, false);				
			panelList.add(object);		
			
			//add to db when batch size is reached
			if(panelList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				panelsMissingRefs.addAll(resolveForeignKeys(db, panelList));
				panelList.removeAll(panelsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(panelList,dbAction, "Identifier");
				
				//clear for next batch						
				panelList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!panelList.isEmpty())
		{
			total.set(total.get() + panelList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			panelsMissingRefs.addAll(resolveForeignKeys(db, panelList));
			panelList.removeAll(panelsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(panelList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Panel> panels = new ArrayList<Panel>(panelsMissingRefs);

		int iterationCount = 0;

		do
		{
			panelsMissingRefs = resolveForeignKeys(db, panelsMissingRefs);
			
			LinkedHashSet<Panel> differenceSet = new LinkedHashSet<Panel>();
			Sets.symmetricDifference(new LinkedHashSet<Panel>(panels), new LinkedHashSet<Panel>(panelsMissingRefs)).copyInto(differenceSet);
			List<Panel> resolvablepanels = new ArrayList<Panel>(differenceSet);
			
			panels.removeAll(resolvablepanels);
			
			db.update(resolvablepanels,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Panel blaat : panelsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'panel' entity failed:"
								+ "This is probably caused by a(n) 'panel' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (panelsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " panel from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param panelList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Panel> resolveForeignKeys(Database db, List<Panel> panelList) throws Exception
	{
		//keep a list of Panel instances that miss a reference which might be resolvable later
		List<Panel> panelsMissingRefs = new ArrayList<Panel>();
	
		//resolve xref 'panelType' from ontologyTerm.Identifier -> ontologyTerm.id
		for(Panel o: panelList) 
		{
			if(o.getPanelType_Identifier() != null) 
				panelTypeKeymap.put(o.getPanelType_Identifier(), null);
		}
		
		if(panelTypeKeymap.size() > 0) 
		{
			List<OntologyTerm> panelTypeList = db.query(OntologyTerm.class).in("Identifier",new ArrayList<Object>(panelTypeKeymap.keySet())).find();
			for(OntologyTerm xref :  panelTypeList)
			{
				panelTypeKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'species' from species.Identifier -> species.id
		for(Panel o: panelList) 
		{
			if(o.getSpecies_Identifier() != null) 
				speciesKeymap.put(o.getSpecies_Identifier(), null);
		}
		
		if(speciesKeymap.size() > 0) 
		{
			List<Species> speciesList = db.query(Species.class).in("Identifier",new ArrayList<Object>(speciesKeymap.keySet())).find();
			for(Species xref :  speciesList)
			{
				speciesKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'individuals' from individual.Identifier -> individual.id
		for(Panel o: panelList) for(String xref_label: o.getIndividuals_Identifier())
		{
			if(xref_label != null) 
				individualsKeymap.put(xref_label.trim(), null);
		}
		
		if(individualsKeymap.size() > 0) 
		{
			List<Individual> individualsList = db.query(Individual.class).in("Identifier",new ArrayList<Object>(individualsKeymap.keySet())).find();
			for(Individual xref :  individualsList)
			{
				individualsKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Panel o:  panelList)
		{
			while(true){
				//update xref PanelType
				if(o.getPanelType_Identifier() != null) 
				{
					String key = o.getPanelType_Identifier();
					if(panelTypeKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Panel' objects failed: cannot find OntologyTerm for panelType_Identifier='"+o.getPanelType_Identifier()+"'");
					}
					o.setPanelType_Id(panelTypeKeymap.get(key));
				}
				//update xref Species
				if(o.getSpecies_Identifier() != null) 
				{
					String key = o.getSpecies_Identifier();
					if(speciesKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Panel' objects failed: cannot find Species for species_Identifier='"+o.getSpecies_Identifier()+"'");
					}
					o.setSpecies_Id(speciesKeymap.get(key));
				}
				//update mref Individuals
				if(o.getIndividuals_Identifier() != null) 
				{
					List<Integer> mrefs = new ArrayList<Integer>();
					boolean breakToNextPanel = false;

					int listSize = 0;
					if(o.getIndividuals_Identifier() != null) listSize = Math.max(o.getIndividuals_Identifier().size(), listSize);
					for(int i = 0; i < listSize; i++)
					{
						String key = o.getIndividuals_Identifier().get(i);
							key = key.trim();				
						if(individualsKeymap.get(key) == null){
							logger.error("Import of 'Panel' objects failed: "+o);
							throw new Exception("Import of 'Panel' objects failed:" 
							+"cannot find individuals_Identifier='"+(o.getIndividuals_Identifier() != null && i < o.getIndividuals_Identifier().size() ? o.getIndividuals_Identifier().get(i) : "null")+"'");
						}
						mrefs.add(individualsKeymap.get(key));
					}
					if(breakToNextPanel){
						break;
					}
					o.setIndividuals_Id(mrefs);
				}
				break;
			}
		}
		
		panelTypeKeymap.clear();
		speciesKeymap.clear();
		individualsKeymap.clear();
		
		return panelsMissingRefs;
	}
}

