/* File:        org.molgenis.omx/model/XrefValue.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 14, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.value.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class XrefValueJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.observ.value.XrefValue>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(XrefValueJpaMapper.class);

	public XrefValueJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT XrefValue.id"
			+", Value.__Type"
			+", XrefValue.Value"
			//parent is SimpleTree(name='Value')
			+", xref_Value.Identifier AS Value_Identifier"
			+" FROM XrefValue "
			+" INNER JOIN Value ON (XrefValue.id = Value.id)"

			
			//label for Value=Identifier
//path==Value. type==xref.
//path==Value_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Value " 
			+" ON xref_Value.id = XrefValue.Value"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.observ.value.XrefValue entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'Value' is known in the databse
			if(entity.getValue() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getValue().getIdValue() == null)
					new org.molgenis.omx.observ.db.CharacteristicJpaMapper(getDatabase()).create(entity.getValue());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getValue()) && entity.getValue().getIdValue() != null)
					entity.setValue(getEntityManager().getReference(org.molgenis.omx.observ.Characteristic.class, entity.getValue().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getValue_Id() != null) {
					entity.setValue((org.molgenis.omx.observ.Characteristic)getEntityManager().find(org.molgenis.omx.observ.Characteristic.class, entity.getValue_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.observ.value.XrefValue xrefValue) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				xrefValue = getEntityManager().getReference(org.molgenis.omx.observ.value.XrefValue.class, xrefValue.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The xrefValue with id " + xrefValue.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(xrefValue);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.observ.value.XrefValue xrefValue) throws org.molgenis.framework.db.DatabaseException {
		try {




			//3
			org.molgenis.omx.observ.Characteristic valueNew = xrefValue.getValue();

			if (valueNew == null) { //object is reference by xref		
                            if(xrefValue.getValue_Id() != null) {
                                xrefValue.setValue((org.molgenis.omx.observ.Characteristic)getEntityManager().find(org.molgenis.omx.observ.Characteristic.class, xrefValue.getValue_Id()));
                            }
			}
			if(!getEntityManager().contains(xrefValue)) {
				xrefValue = getEntityManager().merge(xrefValue);
			}
			

		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.observ.value.XrefValue> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.observ.value.XrefValue xrefValue : entities) 
			{
				create(xrefValue);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.observ.value.XrefValue> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.observ.value.XrefValue xrefValue : entities) 
			{
				edit(xrefValue);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.observ.value.XrefValue> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.observ.value.XrefValue xrefValue : entities) 
			{
				destroy(xrefValue);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("XrefValue_id".equalsIgnoreCase(fieldName)) return "id";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("XrefValue___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Value".equalsIgnoreCase(fieldName)) return "Value";
		if("XrefValue_Value".equalsIgnoreCase(fieldName)) return "Value";
		if("Value_id".equalsIgnoreCase(fieldName)) return "Value";
		if("XrefValue_Value_id".equalsIgnoreCase(fieldName)) return "Value";
		if("Value_Identifier".equalsIgnoreCase(fieldName)) return "Value.Identifier";	
		if("XrefValue_Value_Identifier".equalsIgnoreCase(fieldName)) return "Value.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.observ.value.XrefValue> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.observ.value.XrefValue>(size);
	}			

	@Override
	public org.molgenis.omx.observ.value.XrefValue create()
	{
		return new org.molgenis.omx.observ.value.XrefValue();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.observ.value.XrefValue> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'value' to characteristic.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> valueRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.observ.value.XrefValue object: entities)
		{
			//create xref/mref rule filtering Characteristic on the label Identifier
			if(object.getValue_Id() == null && object.getValue_Identifier() != null)
			{
				Object label = object.getValue_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!valueRules.containsKey(label))
					{
						valueRules.put(""+label, xrefFilter);
						valueRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'value' to characteristic.id using Identifier)
		final java.util.Map<String,Integer> value_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(valueRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.Characteristic> valueList = null;
			try
			{
				valueList = getDatabase().find(org.molgenis.omx.observ.Characteristic.class, valueRules.values().toArray(new org.molgenis.framework.db.QueryRule[valueRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.Characteristic xref :  valueList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				value_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.observ.value.XrefValue object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getValue_Id() == null )
			{
					String key = "";
					if(object.getValue_Identifier() != null)
						key += 	object.getValue_Identifier();
					
					if(!"".equals(key) && value_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Value_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setValue_Id(value_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "xrefValue.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("__Type".equalsIgnoreCase(fieldName) || "value.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("value".equalsIgnoreCase(fieldName) || "xrefValue.value".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.observ.value.XrefValue> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.observ.value.XrefValue> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
