package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.Characteristic;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class CharacteristicService
{
	private static final Logger logger = Logger.getLogger(CharacteristicService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_CHARACTERISTIC')")
	public Characteristic create(Characteristic characteristic) throws DatabaseException
	{
		logger.debug("creating Characteristic");
		db.add(characteristic);
		return characteristic;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_CHARACTERISTIC')")
	public Characteristic read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Characteristic");
		return db.findById(Characteristic.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_CHARACTERISTIC')")
	public void update(Characteristic characteristic) throws DatabaseException
	{
		logger.debug("updating Characteristic");
		db.update(characteristic);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_CHARACTERISTIC')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Characteristic");
		Characteristic characteristic = db.findById(Characteristic.class, id);
		return db.remove(characteristic) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_CHARACTERISTIC')")
	public Iterable<Characteristic> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Characteristic instances");
		return db.find(Characteristic.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_CHARACTERISTIC')")
	public EntityPager<Characteristic> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Characteristic instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Characteristic.class, queryRules.toArray(new QueryRule[0]));
		List<Characteristic> characteristicCollection = db.find(Characteristic.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Characteristic>(start, num, count, characteristicCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_CHARACTERISTIC')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Characteristic");
	}
}