package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.target.Individual;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class IndividualService
{
	private static final Logger logger = Logger.getLogger(IndividualService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_INDIVIDUAL')")
	public Individual create(Individual individual) throws DatabaseException
	{
		logger.debug("creating Individual");
		db.add(individual);
		return individual;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_INDIVIDUAL')")
	public Individual read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Individual");
		return db.findById(Individual.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_INDIVIDUAL')")
	public void update(Individual individual) throws DatabaseException
	{
		logger.debug("updating Individual");
		db.update(individual);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_INDIVIDUAL')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Individual");
		Individual individual = db.findById(Individual.class, id);
		return db.remove(individual) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_INDIVIDUAL')")
	public Iterable<Individual> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Individual instances");
		return db.find(Individual.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_INDIVIDUAL')")
	public EntityPager<Individual> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Individual instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Individual.class, queryRules.toArray(new QueryRule[0]));
		List<Individual> individualCollection = db.find(Individual.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Individual>(start, num, count, individualCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_INDIVIDUAL')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Individual");
	}
}