package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.auth.Institute;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class InstituteService
{
	private static final Logger logger = Logger.getLogger(InstituteService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_INSTITUTE')")
	public Institute create(Institute institute) throws DatabaseException
	{
		logger.debug("creating Institute");
		db.add(institute);
		return institute;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_INSTITUTE')")
	public Institute read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Institute");
		return db.findById(Institute.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_INSTITUTE')")
	public void update(Institute institute) throws DatabaseException
	{
		logger.debug("updating Institute");
		db.update(institute);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_INSTITUTE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Institute");
		Institute institute = db.findById(Institute.class, id);
		return db.remove(institute) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_INSTITUTE')")
	public Iterable<Institute> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Institute instances");
		return db.find(Institute.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_INSTITUTE')")
	public EntityPager<Institute> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Institute instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Institute.class, queryRules.toArray(new QueryRule[0]));
		List<Institute> instituteCollection = db.find(Institute.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Institute>(start, num, count, instituteCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_INSTITUTE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Institute");
	}
}