package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.ObservationSet;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ObservationSetService
{
	private static final Logger logger = Logger.getLogger(ObservationSetService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_OBSERVATIONSET')")
	public ObservationSet create(ObservationSet observationSet) throws DatabaseException
	{
		logger.debug("creating ObservationSet");
		db.add(observationSet);
		return observationSet;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_OBSERVATIONSET')")
	public ObservationSet read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving ObservationSet");
		return db.findById(ObservationSet.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_OBSERVATIONSET')")
	public void update(ObservationSet observationSet) throws DatabaseException
	{
		logger.debug("updating ObservationSet");
		db.update(observationSet);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_OBSERVATIONSET')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting ObservationSet");
		ObservationSet observationSet = db.findById(ObservationSet.class, id);
		return db.remove(observationSet) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_OBSERVATIONSET')")
	public Iterable<ObservationSet> readAll() throws DatabaseException
	{
		logger.debug("retrieving all ObservationSet instances");
		return db.find(ObservationSet.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_OBSERVATIONSET')")
	public EntityPager<ObservationSet> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all ObservationSet instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(ObservationSet.class, queryRules.toArray(new QueryRule[0]));
		List<ObservationSet> observationSetCollection = db.find(ObservationSet.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<ObservationSet>(start, num, count, observationSetCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_OBSERVATIONSET')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("ObservationSet");
	}
}