package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.ObservedValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ObservedValueService
{
	private static final Logger logger = Logger.getLogger(ObservedValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_OBSERVEDVALUE')")
	public ObservedValue create(ObservedValue observedValue) throws DatabaseException
	{
		logger.debug("creating ObservedValue");
		db.add(observedValue);
		return observedValue;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_OBSERVEDVALUE')")
	public ObservedValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving ObservedValue");
		return db.findById(ObservedValue.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_OBSERVEDVALUE')")
	public void update(ObservedValue observedValue) throws DatabaseException
	{
		logger.debug("updating ObservedValue");
		db.update(observedValue);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_OBSERVEDVALUE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting ObservedValue");
		ObservedValue observedValue = db.findById(ObservedValue.class, id);
		return db.remove(observedValue) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_OBSERVEDVALUE')")
	public Iterable<ObservedValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all ObservedValue instances");
		return db.find(ObservedValue.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_OBSERVEDVALUE')")
	public EntityPager<ObservedValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all ObservedValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(ObservedValue.class, queryRules.toArray(new QueryRule[0]));
		List<ObservedValue> observedValueCollection = db.find(ObservedValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<ObservedValue>(start, num, count, observedValueCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_OBSERVEDVALUE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("ObservedValue");
	}
}