package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.target.Ontology;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class OntologyService
{
	private static final Logger logger = Logger.getLogger(OntologyService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_ONTOLOGY')")
	public Ontology create(Ontology ontology) throws DatabaseException
	{
		logger.debug("creating Ontology");
		db.add(ontology);
		return ontology;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_ONTOLOGY')")
	public Ontology read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Ontology");
		return db.findById(Ontology.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_ONTOLOGY')")
	public void update(Ontology ontology) throws DatabaseException
	{
		logger.debug("updating Ontology");
		db.update(ontology);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_ONTOLOGY')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Ontology");
		Ontology ontology = db.findById(Ontology.class, id);
		return db.remove(ontology) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_ONTOLOGY')")
	public Iterable<Ontology> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Ontology instances");
		return db.find(Ontology.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_ONTOLOGY')")
	public EntityPager<Ontology> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Ontology instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Ontology.class, queryRules.toArray(new QueryRule[0]));
		List<Ontology> ontologyCollection = db.find(Ontology.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Ontology>(start, num, count, ontologyCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_ONTOLOGY')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Ontology");
	}
}