package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.auth.PersonRole;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PersonRoleService
{
	private static final Logger logger = Logger.getLogger(PersonRoleService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PERSONROLE')")
	public PersonRole create(PersonRole personRole) throws DatabaseException
	{
		logger.debug("creating PersonRole");
		db.add(personRole);
		return personRole;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PERSONROLE')")
	public PersonRole read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving PersonRole");
		return db.findById(PersonRole.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PERSONROLE')")
	public void update(PersonRole personRole) throws DatabaseException
	{
		logger.debug("updating PersonRole");
		db.update(personRole);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PERSONROLE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting PersonRole");
		PersonRole personRole = db.findById(PersonRole.class, id);
		return db.remove(personRole) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PERSONROLE')")
	public Iterable<PersonRole> readAll() throws DatabaseException
	{
		logger.debug("retrieving all PersonRole instances");
		return db.find(PersonRole.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PERSONROLE')")
	public EntityPager<PersonRole> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all PersonRole instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(PersonRole.class, queryRules.toArray(new QueryRule[0]));
		List<PersonRole> personRoleCollection = db.find(PersonRole.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<PersonRole>(start, num, count, personRoleCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PERSONROLE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("PersonRole");
	}
}