package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.target.Species;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class SpeciesService
{
	private static final Logger logger = Logger.getLogger(SpeciesService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_SPECIES')")
	public Species create(Species species) throws DatabaseException
	{
		logger.debug("creating Species");
		db.add(species);
		return species;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_SPECIES')")
	public Species read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Species");
		return db.findById(Species.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_SPECIES')")
	public void update(Species species) throws DatabaseException
	{
		logger.debug("updating Species");
		db.update(species);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_SPECIES')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Species");
		Species species = db.findById(Species.class, id);
		return db.remove(species) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_SPECIES')")
	public Iterable<Species> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Species instances");
		return db.find(Species.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_SPECIES')")
	public EntityPager<Species> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Species instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Species.class, queryRules.toArray(new QueryRule[0]));
		List<Species> speciesCollection = db.find(Species.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Species>(start, num, count, speciesCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_SPECIES')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Species");
	}
}