package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.StringValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class StringValueService
{
	private static final Logger logger = Logger.getLogger(StringValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_STRINGVALUE')")
	public StringValue create(StringValue stringValue) throws DatabaseException
	{
		logger.debug("creating StringValue");
		db.add(stringValue);
		return stringValue;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_STRINGVALUE')")
	public StringValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving StringValue");
		return db.findById(StringValue.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_STRINGVALUE')")
	public void update(StringValue stringValue) throws DatabaseException
	{
		logger.debug("updating StringValue");
		db.update(stringValue);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_STRINGVALUE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting StringValue");
		StringValue stringValue = db.findById(StringValue.class, id);
		return db.remove(stringValue) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_STRINGVALUE')")
	public Iterable<StringValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all StringValue instances");
		return db.find(StringValue.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_STRINGVALUE')")
	public EntityPager<StringValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all StringValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(StringValue.class, queryRules.toArray(new QueryRule[0]));
		List<StringValue> stringValueCollection = db.find(StringValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<StringValue>(start, num, count, stringValueCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_STRINGVALUE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("StringValue");
	}
}