
/* File:        org.molgenis.omx/model/Person.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.auth.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.auth.Institute;
import org.molgenis.omx.auth.PersonRole;
import org.molgenis.omx.auth.Person;


/**
 * Reads Person from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class PersonEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(PersonEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'affiliation' (maps institute.Name -> institute.id)			
	final Map<String,Integer> affiliationKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'roles' (maps personRole.Identifier -> personRole.id)			
	final Map<String,Integer> rolesKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Person from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Person> personsMissingRefs = new ArrayList<Person>();
	
		//cache for objects to be imported from file (in batch)
		final List<Person> personList = new ArrayList<Person>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Person object = new Person();
			object.set(entity, false);				
			personList.add(object);		
			
			//add to db when batch size is reached
			if(personList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				personsMissingRefs.addAll(resolveForeignKeys(db, personList));
				personList.removeAll(personsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Name' defined in xref_label
				db.update(personList,dbAction, "Name");
				
				//clear for next batch						
				personList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!personList.isEmpty())
		{
			total.set(total.get() + personList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			personsMissingRefs.addAll(resolveForeignKeys(db, personList));
			personList.removeAll(personsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Name' defined in xref_label
			db.update(personList,dbAction, "Name");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Person> persons = new ArrayList<Person>(personsMissingRefs);

		int iterationCount = 0;

		do
		{
			personsMissingRefs = resolveForeignKeys(db, personsMissingRefs);
			
			LinkedHashSet<Person> differenceSet = new LinkedHashSet<Person>();
			Sets.symmetricDifference(new LinkedHashSet<Person>(persons), new LinkedHashSet<Person>(personsMissingRefs)).copyInto(differenceSet);
			List<Person> resolvablepersons = new ArrayList<Person>(differenceSet);
			
			persons.removeAll(resolvablepersons);
			
			db.update(resolvablepersons,dbAction, "Name");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Person blaat : personsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'person' entity failed:"
								+ "This is probably caused by a(n) 'person' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (personsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " person from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param personList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Person> resolveForeignKeys(Database db, List<Person> personList) throws Exception
	{
		//keep a list of Person instances that miss a reference which might be resolvable later
		List<Person> personsMissingRefs = new ArrayList<Person>();
	
		//resolve xref 'affiliation' from institute.Name -> institute.id
		for(Person o: personList) 
		{
			if(o.getAffiliation_Name() != null) 
				affiliationKeymap.put(o.getAffiliation_Name(), null);
		}
		
		if(affiliationKeymap.size() > 0) 
		{
			List<Institute> affiliationList = db.query(Institute.class).in("Name",new ArrayList<Object>(affiliationKeymap.keySet())).find();
			for(Institute xref :  affiliationList)
			{
				affiliationKeymap.put(xref.getName(), xref.getId());
			}
		}
		//resolve xref 'roles' from personRole.Identifier -> personRole.id
		for(Person o: personList) 
		{
			if(o.getRoles_Identifier() != null) 
				rolesKeymap.put(o.getRoles_Identifier(), null);
		}
		
		if(rolesKeymap.size() > 0) 
		{
			List<PersonRole> rolesList = db.query(PersonRole.class).in("Identifier",new ArrayList<Object>(rolesKeymap.keySet())).find();
			for(PersonRole xref :  rolesList)
			{
				rolesKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Person o:  personList)
		{
			while(true){
				//update xref Affiliation
				if(o.getAffiliation_Name() != null) 
				{
					String key = o.getAffiliation_Name();
					if(affiliationKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Person' objects failed: cannot find Institute for affiliation_Name='"+o.getAffiliation_Name()+"'");
					}
					o.setAffiliation_Id(affiliationKeymap.get(key));
				}
				//update xref Roles
				if(o.getRoles_Identifier() != null) 
				{
					String key = o.getRoles_Identifier();
					if(rolesKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Person' objects failed: cannot find PersonRole for roles_Identifier='"+o.getRoles_Identifier()+"'");
					}
					o.setRoles_Id(rolesKeymap.get(key));
				}
				break;
			}
		}
		
		affiliationKeymap.clear();
		rolesKeymap.clear();
		
		return personsMissingRefs;
	}
}

