
/* File:        org.molgenis.omx/model/PersonRole.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.auth.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.target.Ontology;
import org.molgenis.omx.auth.PersonRole;


/**
 * Reads PersonRole from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class PersonRoleEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(PersonRoleEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'ontology' (maps ontology.Identifier -> ontology.id)			
	final Map<String,Integer> ontologyKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports PersonRole from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<PersonRole> personRolesMissingRefs = new ArrayList<PersonRole>();
	
		//cache for objects to be imported from file (in batch)
		final List<PersonRole> personRoleList = new ArrayList<PersonRole>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			PersonRole object = new PersonRole();
			object.set(entity, false);				
			personRoleList.add(object);		
			
			//add to db when batch size is reached
			if(personRoleList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				personRolesMissingRefs.addAll(resolveForeignKeys(db, personRoleList));
				personRoleList.removeAll(personRolesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(personRoleList,dbAction, "Identifier");
				
				//clear for next batch						
				personRoleList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!personRoleList.isEmpty())
		{
			total.set(total.get() + personRoleList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			personRolesMissingRefs.addAll(resolveForeignKeys(db, personRoleList));
			personRoleList.removeAll(personRolesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(personRoleList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<PersonRole> personRoles = new ArrayList<PersonRole>(personRolesMissingRefs);

		int iterationCount = 0;

		do
		{
			personRolesMissingRefs = resolveForeignKeys(db, personRolesMissingRefs);
			
			LinkedHashSet<PersonRole> differenceSet = new LinkedHashSet<PersonRole>();
			Sets.symmetricDifference(new LinkedHashSet<PersonRole>(personRoles), new LinkedHashSet<PersonRole>(personRolesMissingRefs)).copyInto(differenceSet);
			List<PersonRole> resolvablepersonRoles = new ArrayList<PersonRole>(differenceSet);
			
			personRoles.removeAll(resolvablepersonRoles);
			
			db.update(resolvablepersonRoles,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(PersonRole blaat : personRolesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'personRole' entity failed:"
								+ "This is probably caused by a(n) 'personRole' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (personRolesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " personRole from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param personRoleList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<PersonRole> resolveForeignKeys(Database db, List<PersonRole> personRoleList) throws Exception
	{
		//keep a list of PersonRole instances that miss a reference which might be resolvable later
		List<PersonRole> personRolesMissingRefs = new ArrayList<PersonRole>();
	
		//resolve xref 'ontology' from ontology.Identifier -> ontology.id
		for(PersonRole o: personRoleList) 
		{
			if(o.getOntology_Identifier() != null) 
				ontologyKeymap.put(o.getOntology_Identifier(), null);
		}
		
		if(ontologyKeymap.size() > 0) 
		{
			List<Ontology> ontologyList = db.query(Ontology.class).in("Identifier",new ArrayList<Object>(ontologyKeymap.keySet())).find();
			for(Ontology xref :  ontologyList)
			{
				ontologyKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(PersonRole o:  personRoleList)
		{
			while(true){
				//update xref ontology
				if(o.getOntology_Identifier() != null) 
				{
					String key = o.getOntology_Identifier();
					if(ontologyKeymap.get(key) == null)
					{
						throw new Exception("Import of 'PersonRole' objects failed: cannot find Ontology for ontology_Identifier='"+o.getOntology_Identifier()+"'");
					}
					o.setOntology_Id(ontologyKeymap.get(key));
				}
				break;
			}
		}
		
		ontologyKeymap.clear();
		
		return personRolesMissingRefs;
	}
}

