
/* File:        org.molgenis.omx/model/ObservableFeature.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ;

/**
 * ObservableFeature: 
				ObservableFeature defines anything that can be observed.
				<p/>
				In other words, ObservableFeature are the questions asked, e.g. 'What
				is Height?', 'What is Systolic blood pressure?', or 'Has blue eyes?'.
				<p/>
				Some questions may be repeated for multiple characteristics. For
				example 'What is [MarkerAllele] observed?' can be applied to all
				elements of a MarkerSet, and 'What is [medicin codes] uses' can be
				applied to a set of Medicine codes. This can be specified using the
				measuredCharacteristic field.
				<p/>
				The identifier of ObservableFeature is globally unique. It is
				recommended that each ObservableFeature is named according to a
				well-defined ontology term or database accession.
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "ObservableFeature"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.observ.db.ObservableFeatureEntityListener.class})
public class ObservableFeature extends org.molgenis.omx.observ.Characteristic 
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String UNIT = "unit";
	public final static String UNIT_IDENTIFIER = "unit_Identifier";
	public final static String DEFINITIONS = "definitions";
	public final static String DEFINITIONS_IDENTIFIER = "definitions_Identifier";
	public final static String DATATYPE = "dataType";
	public final static String TEMPORAL = "temporal";
	public final static String ID = "id";
	
	//static methods
	/**
	 * Shorthand for db.query(ObservableFeature.class).
	 */
	public static org.molgenis.framework.db.Query<? extends ObservableFeature> query(org.molgenis.framework.db.Database db)
	{
		return db.query(ObservableFeature.class);
	}
	
	/**
	 * Shorthand for db.find(ObservableFeature.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends ObservableFeature> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(ObservableFeature.class, rules);
	}	
	
	/**
	 * 
	 */
	public static ObservableFeature findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<ObservableFeature> q = db.query(ObservableFeature.class);
		q = q.eq(ObservableFeature.ID, id);
		java.util.List<ObservableFeature> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static ObservableFeature findByIdentifier(org.molgenis.framework.db.Database db, String identifier) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<ObservableFeature> q = db.query(ObservableFeature.class);
		q = q.eq(ObservableFeature.IDENTIFIER, identifier);
		java.util.List<ObservableFeature> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//(Optional) Reference to the well-defined measurement unit used to observe this feature       (if feature is that concrete). E.g. mmHg[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="unit")   	
	
				

	private org.molgenis.omx.observ.target.OntologyTerm unit = null;
	@javax.persistence.Transient
	private Integer unit_id = null;	
	@javax.persistence.Transient
	private String unit_Identifier = null;						

	//The concept that is being measured in a specific way.[type=mref]
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="definitions", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="ObservableFeature_definitions", 
			joinColumns=@javax.persistence.JoinColumn(name="ObservableFeature"), inverseJoinColumns=@javax.persistence.JoinColumn(name="definitions"))
	
				

	private java.util.List<org.molgenis.omx.observ.target.OntologyTerm> definitions = new java.util.ArrayList<org.molgenis.omx.observ.target.OntologyTerm>();
	@javax.persistence.Transient
	private java.util.List<Integer> definitions_id = new java.util.ArrayList<Integer>();		
	@javax.persistence.Transient
	private java.util.List<String> definitions_Identifier = new java.util.ArrayList<String>();

	//(Optional) Reference to the technical data type. E.g. 'int'[type=enum]
	@javax.persistence.Column(name="dataType", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="dataType")
	
				

	@javax.validation.constraints.NotNull
	private String dataType =  "string";
	@javax.persistence.Transient
	private String dataType_label = null;
	@javax.persistence.Transient
	private static final java.util.List<org.molgenis.util.ValueLabel> dataType_options;
	
	static {
		dataType_options = new java.util.ArrayList<org.molgenis.util.ValueLabel>();
		dataType_options.add(new org.molgenis.util.ValueLabel("bool","bool"));
		dataType_options.add(new org.molgenis.util.ValueLabel("categorical","categorical"));
		dataType_options.add(new org.molgenis.util.ValueLabel("date","date"));
		dataType_options.add(new org.molgenis.util.ValueLabel("datetime","datetime"));
		dataType_options.add(new org.molgenis.util.ValueLabel("decimal","decimal"));
		dataType_options.add(new org.molgenis.util.ValueLabel("email","email"));
		dataType_options.add(new org.molgenis.util.ValueLabel("enum","enum"));
		dataType_options.add(new org.molgenis.util.ValueLabel("file","file"));
		dataType_options.add(new org.molgenis.util.ValueLabel("html","html"));
		dataType_options.add(new org.molgenis.util.ValueLabel("hyperlink","hyperlink"));
		dataType_options.add(new org.molgenis.util.ValueLabel("image","image"));
		dataType_options.add(new org.molgenis.util.ValueLabel("int","int"));
		dataType_options.add(new org.molgenis.util.ValueLabel("long","long"));
		dataType_options.add(new org.molgenis.util.ValueLabel("mref","mref"));
		dataType_options.add(new org.molgenis.util.ValueLabel("string","string"));
		dataType_options.add(new org.molgenis.util.ValueLabel("text","text"));
		dataType_options.add(new org.molgenis.util.ValueLabel("xref","xref"));
	}

	//Whether this feature is time dependent and can have different values when measured       on different times (e.g. weight, temporal=true) or generally only measured once (e.g. birth date,       temporal=false)[type=bool]
	@javax.persistence.Column(name="temporal", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="temporal")
	
				

	@javax.validation.constraints.NotNull
	private Boolean temporal =  false;

	//automatically generated internal id, only for internal use.[type=int]
	

	//constructors
	public ObservableFeature()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	/** copy constructor */
	public ObservableFeature(ObservableFeature copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the (Optional) Reference to the well-defined measurement unit used to observe this feature       (if feature is that concrete). E.g. mmHg.
	 * @return unit.
	 */
	public org.molgenis.omx.observ.target.OntologyTerm getUnit()
	{
		return this.unit;
	}
	
	@Deprecated
	public org.molgenis.omx.observ.target.OntologyTerm getUnit(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the (Optional) Reference to the well-defined measurement unit used to observe this feature       (if feature is that concrete). E.g. mmHg.
	 * @param unit
	 */
	public void setUnit( org.molgenis.omx.observ.target.OntologyTerm unit)
	{
		
		this.unit = unit;
	}

	
	
	/**
	 * Set foreign key for field unit.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setUnit_Id(Integer unit_id)
	{
		this.unit_id = unit_id;
	}	

	public void setUnit(Integer unit_id)
	{
		this.unit_id = unit_id;
	}
	
	public Integer getUnit_Id()
	{
		
		if(unit != null) 
		{
			return unit.getId();
		}
		else
		{
			return unit_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference Unit to OntologyTerm.Id.
	 */
	public String getUnit_Identifier()
	{		
		//FIXME should we auto-load based on getUnit()?	
		if(unit != null) {
			return unit.getIdentifier();
		} else {
			return unit_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Unit to <a href="OntologyTerm.html#Id">OntologyTerm.Id</a>.
	 * Implies setUnit(null) until save
	 */
	public void setUnit_Identifier(String unit_Identifier)
	{
		this.unit_Identifier = unit_Identifier;
	}		
	 
	

	/**
	 * Get the The concept that is being measured in a specific way..
	 * @return definitions.
	 */
	public java.util.List<org.molgenis.omx.observ.target.OntologyTerm> getDefinitions()
	{
		return this.definitions;
	}
	
	@Deprecated
	public java.util.List<org.molgenis.omx.observ.target.OntologyTerm> getDefinitions(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The concept that is being measured in a specific way..
	 * @param definitions
	 */
	public void setDefinitions( java.util.List<org.molgenis.omx.observ.target.OntologyTerm> definitions)
	{
		
		this.definitions = definitions;
	}

	
	public void setDefinitions_Id(Integer ... definitions)
	{
		this.setDefinitions_Id(java.util.Arrays.asList(definitions));
	}	
	
	public void setDefinitions(org.molgenis.omx.observ.target.OntologyTerm ... definitions)
	{
		this.setDefinitions(java.util.Arrays.asList(definitions));
	}	
	
	/**
	 * Set foreign key for field definitions.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setDefinitions_Id(java.util.List<Integer> definitions_id)
	{
		this.definitions_id = definitions_id;
	}	
	
	public java.util.List<Integer> getDefinitions_Id()
	{
		if(definitions != null && !definitions.isEmpty()) {
			java.util.List<Integer> result = new java.util.ArrayList<Integer>();
			for (int i = 0; i < definitions.size(); i++)
				result.add(definitions.get(i).getId());
			return result;
		} else {
			if(definitions_id == null) {
				definitions_id = new java.util.ArrayList<Integer>();
			}		
			return definitions_id;
		}
	}	
	
	/**
	 * Get a pretty label for cross reference Definitions to <a href="OntologyTerm.html#Id">OntologyTerm.Id</a>.
	 */
	public java.util.List<String> getDefinitions_Identifier()
	{
		if(this.definitions != null && !this.definitions.isEmpty())
		{
			java.util.List<String> result = new java.util.ArrayList<String>(this.definitions.size());
			for(org.molgenis.omx.observ.target.OntologyTerm o: definitions) result.add(o.getIdentifier());
			return java.util.Collections.unmodifiableList(result);
		}	
		else
		{	
			return definitions_Identifier;
		}
	}
	
	/**
	 * Update the foreign key Definitions
	 * This sets definitions to null until next database transaction.
	 */
	public void setDefinitions_Identifier(java.util.List<String> definitions_Identifier)
	{
		this.definitions_Identifier = definitions_Identifier;
	}		
	

	/**
	 * Get the (Optional) Reference to the technical data type. E.g. 'int'.
	 * @return dataType.
	 */
	public String getDataType()
	{
		return this.dataType;
	}
	
	@Deprecated
	public String getDataType(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the (Optional) Reference to the technical data type. E.g. 'int'.
	 * @param dataType
	 */
	public void setDataType( String dataType)
	{
		
		this.dataType = dataType;
	}

	
	/**
	 * Get tha label for enum DataType.
	 */
	public String getDataTypeLabel()
	{
		return this.dataType_label;
	}
	/**
	 * DataType is enum. This method returns all available enum options.
	 */
	public java.util.List<org.molgenis.util.ValueLabel> getDataTypeOptions()
	{
		return dataType_options;
	}	
	

	/**
	 * Get the Whether this feature is time dependent and can have different values when measured       on different times (e.g. weight, temporal=true) or generally only measured once (e.g. birth date,       temporal=false).
	 * @return temporal.
	 */
	public Boolean getTemporal()
	{
		return this.temporal;
	}
	
	@Deprecated
	public Boolean getTemporal(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Whether this feature is time dependent and can have different values when measured       on different times (e.g. weight, temporal=true) or generally only measured once (e.g. birth date,       temporal=false).
	 * @param temporal
	 */
	public void setTemporal( Boolean temporal)
	{
		
		this.temporal = temporal;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();
		if (name.equals("description"))
			return getDescription();
		if (name.equals("unit"))
			return getUnit();
		if(name.equals("unit_id"))
			return getUnit_Id();
		if(name.equals("unit_identifier"))
			return getUnit_Identifier();
		if (name.equals("definitions"))
			return getDefinitions();
		if(name.equals("definitions_id"))
			return getDefinitions_Id();
		if(name.equals("definitions_identifier"))
			return getDefinitions_Identifier();
		if (name.equals("datatype"))
			return getDataType();
		if(name.equals("datatype_label"))
			return getDataTypeLabel();
		if (name.equals("temporal"))
			return getTemporal();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getIdentifier() == null) throw new org.molgenis.framework.db.DatabaseException("required field identifier is null");
		if(this.getName() == null) throw new org.molgenis.framework.db.DatabaseException("required field name is null");
		if(this.get__Type() == null) throw new org.molgenis.framework.db.DatabaseException("required field __Type is null");
		if(this.getDataType() == null) throw new org.molgenis.framework.db.DatabaseException("required field dataType is null");
		if(this.getTemporal() == null) throw new org.molgenis.framework.db.DatabaseException("required field temporal is null");
	}
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("observablefeature_id") != null) this.setId(entity.getInt("observablefeature_id"));
		else if( entity.getInt("ObservableFeature_id") != null) this.setId(entity.getInt("ObservableFeature_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("observablefeature_identifier") != null) this.setIdentifier(entity.getString("observablefeature_identifier"));
		else if( entity.getString("ObservableFeature_Identifier") != null) this.setIdentifier(entity.getString("ObservableFeature_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("observablefeature_name") != null) this.setName(entity.getString("observablefeature_name"));
		else if( entity.getString("ObservableFeature_Name") != null) this.setName(entity.getString("ObservableFeature_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("observablefeature___type") != null) this.set__Type(entity.getString("observablefeature___type"));
		else if( entity.getString("ObservableFeature___Type") != null) this.set__Type(entity.getString("ObservableFeature___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("observablefeature_description") != null) this.setDescription(entity.getString("observablefeature_description"));
		else if( entity.getString("ObservableFeature_description") != null) this.setDescription(entity.getString("ObservableFeature_description"));
		//set Unit
		// query formal name, else lowercase name
		if(entity.getInt("unit_id") != null) this.setUnit(entity.getInt("unit_id"));
		else if(entity.getInt("unit_id") != null) this.setUnit(entity.getInt("unit_id"));
		else if(strict) this.setUnit(entity.getInt("unit_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("ObservableFeature_unit_id") != null) this.setUnit(entity.getInt("ObservableFeature_unit_id"));
		else if( entity.getInt("observablefeature_unit_id") != null) this.setUnit(entity.getInt("observablefeature_unit_id"));
		//alias of xref
		if( entity.get("unit") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("unit").toString())) {
				org.molgenis.omx.observ.target.OntologyTerm instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("unit"), org.molgenis.omx.observ.target.OntologyTerm.class);
				this.setUnit(instance);				
			} else {
				this.setUnit_Id(entity.getInt("unit")); 
			}
		}
		else if( entity.get("unit") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("unit").toString())) {
				org.molgenis.omx.observ.target.OntologyTerm instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("unit"), org.molgenis.omx.observ.target.OntologyTerm.class);
				this.setUnit(instance);				
			} else {
				this.setUnit_Id(entity.getInt("unit"));
			}
		}
		if( entity.get("ObservableFeature_unit") != null)
			this.setUnit_Id(entity.getInt("ObservableFeature_unit"));			
		else if( entity.get("observablefeature_unit") != null)
			this.setUnit_Id(entity.getInt("observablefeature_unit"));
			
		if( entity.get("ObservableFeature.unit") != null) 
			this.setUnit((org.molgenis.omx.observ.target.OntologyTerm)entity.get("ObservableFeature.unit_id"));
		else if( entity.get("observablefeature.unit") != null) 
			this.setUnit((org.molgenis.omx.observ.target.OntologyTerm)entity.get("observablefeature.unit_id"));	
		//set label for field Unit
		if(entity.get("unit_Identifier") != null) this.setUnit_Identifier(entity.getString("unit_Identifier"));
		else if(entity.get("unit_identifier") != null) this.setUnit_Identifier(entity.getString("unit_identifier"));
		else if(strict) this.setUnit_Identifier(entity.getString("unit_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("ObservableFeature_unit_Identifier") != null ) this.setUnit_Identifier(entity.getString("ObservableFeature_unit_Identifier"));		
		else if( entity.get("observablefeature_unit_identifier") != null ) this.setUnit_Identifier(entity.getString("observablefeature_unit_identifier"));
		//set Definitions
		if( entity.get("definitions") != null || entity.get("ObservableFeature_definitions") != null || entity.get("definitions") != null || entity.get("observablefeature_definitions") != null) 
		{
			java.util.List<Integer> values = new java.util.ArrayList<Integer>();
			java.util.List<?> mrefs = entity.getList("definitions");
			if(mrefs == null) mrefs = entity.getList("definitions");
			if(entity.get("observablefeature_definitions")!= null) mrefs = entity.getList("observablefeature_definitions");
			else if(entity.get("ObservableFeature_definitions")!= null) mrefs = entity.getList("ObservableFeature_definitions");
			if(mrefs != null) for(Object ref: mrefs)
			{
				if(ref instanceof String)
					values.add(Integer.parseInt((String)ref));
				else if(ref instanceof org.molgenis.util.AbstractEntity) 	
					values.add((Integer)((org.molgenis.util.AbstractEntity)ref).getIdValue() );
				else
					values.add((Integer)ref);		
			}											
			this.setDefinitions_Id( values );
		}
		//set labels Identifier for mref field Definitions	
		if( entity.get("definitions_Identifier") != null || entity.get("ObservableFeature_definitions_Identifier")!= null || entity.get("definitions_identifier") != null || entity.get("observablefeature_definitions_identifier") != null) 
		{
			java.util.List<String> values = new java.util.ArrayList<String>();
			java.util.List<?> mrefs = entity.getList("definitions_Identifier");
			if(mrefs == null) mrefs = entity.getList("definitions_identifier");
			if(entity.get("ObservableFeature_definitions_Identifier")!= null) mrefs = entity.getList("ObservableFeature_definitions_Identifier");
			else if(entity.get("observablefeature_definitions_identifier")!= null) mrefs = entity.getList("observablefeature_definitions_identifier");
			if(mrefs != null) 
				for(Object ref: mrefs)
				{
					String[] refs = ref.toString().split("\\|");
					for(String r : refs) {
						values.add(r);	
					}						
				}							
			this.setDefinitions_Identifier( values );			
		}	
		//set DataType
		// query formal name, else lowercase name
		if(entity.getString("datatype") != null) this.setDataType(entity.getString("datatype"));
		else if(entity.getString("dataType") != null) this.setDataType(entity.getString("dataType"));
		else if(strict) this.setDataType(entity.getString("datatype")); // setting null is not an option due to function overloading
		if( entity.getString("observablefeature_datatype") != null) this.setDataType(entity.getString("observablefeature_datatype"));
		else if( entity.getString("ObservableFeature_dataType") != null) this.setDataType(entity.getString("ObservableFeature_dataType"));
		//set Temporal
		// query formal name, else lowercase name
		if(entity.getBoolean("temporal") != null) this.setTemporal(entity.getBoolean("temporal"));
		else if(entity.getBoolean("temporal") != null) this.setTemporal(entity.getBoolean("temporal"));
		else if(strict) this.setTemporal(entity.getBoolean("temporal")); // setting null is not an option due to function overloading
		if( entity.getBoolean("observablefeature_temporal") != null) this.setTemporal(entity.getBoolean("observablefeature_temporal"));
		else if( entity.getBoolean("ObservableFeature_temporal") != null) this.setTemporal(entity.getBoolean("ObservableFeature_temporal"));
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "ObservableFeature(";
		result+= "id='" + getId()+"' ";	
		result+= "identifier='" + getIdentifier()+"' ";	
		result+= "name='" + getName()+"' ";	
		result+= "__Type='" + get__Type()+"' ";	
		result+= "description='" + getDescription()+"' ";	
		result+= " unit_id='" + getUnit_Id()+"' ";	
		result+= " unit_identifier='" + getUnit_Identifier()+"' ";
		result+= " definitions_id='" + getDefinitions_Id()+"' ";	
		result+= " definitions_identifier='" + getDefinitions_Identifier()+"' ";
		result+= "dataType='" + getDataType()+"' ";	
		result+= "temporal='" + getTemporal()+"'";	
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of ObservableFeature.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Identifier");
		}
		{
			fields.add("Name");
		}
		{
			fields.add("__Type");
		}
		{
			fields.add("description");
		}
		{
			fields.add("unit_id");
		}
		fields.add("unit_Identifier");
		{
			fields.add("definitions_id");
		}
		fields.add("definitions_Identifier");
		{
			fields.add("dataType");
		}
		{
			fields.add("temporal");
		}
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "identifier" +sep
		+ "name" +sep
		+ "__Type" +sep
		+ "description" +sep
		+ "unit" +sep
		+ "definitions" +sep
		+ "dataType" +sep
		+ "temporal" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("unit")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("definitions")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdentifier();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = get__Type();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDescription();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getUnit();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDefinitions();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDataType();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getTemporal();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public ObservableFeature create(org.molgenis.data.Entity entity) throws Exception
	{
		ObservableFeature e = new ObservableFeature();
		e.set(entity);
		return e;
	}
	
	//7
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY, mappedBy="features"/*, cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    private java.util.Collection<org.molgenis.omx.observ.Protocol> featuresProtocolCollection;

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.observ.Protocol> getFeaturesProtocolCollection()
	{
		if(featuresProtocolCollection == null) featuresProtocolCollection = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>(); 
        return featuresProtocolCollection;
	}

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.observ.Protocol> getFeaturesProtocolCollection(org.molgenis.framework.db.Database db)
	{
        return getFeaturesProtocolCollection();
	}

    public void setFeaturesProtocolCollection(java.util.Collection<org.molgenis.omx.observ.Protocol> collection)
    {
		if(featuresProtocolCollection == null) featuresProtocolCollection = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>();
    	featuresProtocolCollection.addAll(collection);
    }	
	//7
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY, mappedBy="requiredFeatures"/*, cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    private java.util.Collection<org.molgenis.omx.observ.Protocol> requiredFeaturesProtocolCollection;

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.observ.Protocol> getRequiredFeaturesProtocolCollection()
	{
		if(requiredFeaturesProtocolCollection == null) requiredFeaturesProtocolCollection = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>(); 
        return requiredFeaturesProtocolCollection;
	}

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.observ.Protocol> getRequiredFeaturesProtocolCollection(org.molgenis.framework.db.Database db)
	{
        return getRequiredFeaturesProtocolCollection();
	}

    public void setRequiredFeaturesProtocolCollection(java.util.Collection<org.molgenis.omx.observ.Protocol> collection)
    {
		if(requiredFeaturesProtocolCollection == null) requiredFeaturesProtocolCollection = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>();
    	requiredFeaturesProtocolCollection.addAll(collection);
    }	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
}
