
/* File:        org.molgenis.omx/model/ObservedValue.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ;

/**
 * ObservedValue: 
				Generic storage of values as part of one observation event. Values are atomatic observations,
				e.g., length (feature) of individual 1 (valueset.target) = 179cm (value).
				Values can also be qualified by some characteristic,
				e.g., QTL p-value (feature) between phenotype 'leaf count'
				(characteristic) and marker 'PVV4' (valueset.target) = 0.1^10+3 (value).
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "ObservedValue"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.observ.db.ObservedValueEntityListener.class})
public class ObservedValue extends org.molgenis.util.AbstractEntity implements org.molgenis.omx.core.Autoid
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String ID = "id";
	public final static String OBSERVATIONSET = "ObservationSet";
	public final static String OBSERVATIONSET_IDENTIFIER = "ObservationSet_Identifier";
	public final static String FEATURE = "Feature";
	public final static String FEATURE_IDENTIFIER = "Feature_Identifier";
	public final static String VALUE = "Value";
	public final static String VALUE_ID = "Value_id";
	
	//static methods
	/**
	 * Shorthand for db.query(ObservedValue.class).
	 */
	public static org.molgenis.framework.db.Query<? extends ObservedValue> query(org.molgenis.framework.db.Database db)
	{
		return db.query(ObservedValue.class);
	}
	
	/**
	 * Shorthand for db.find(ObservedValue.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends ObservedValue> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(ObservedValue.class, rules);
	}	
	
	/**
	 * 
	 */
	public static ObservedValue findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<ObservedValue> q = db.query(ObservedValue.class);
		q = q.eq(ObservedValue.ID, id);
		java.util.List<ObservedValue> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//automatically generated internal id, only for internal use.[type=int]
    @javax.persistence.Id @javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.AUTO)
    @javax.persistence.Column(name="id", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="id")
	
	//@javax.validation.constraints.NotNull
	private Integer id =  null;

	//Reference to the observation. For example a particular patient visit or the application of a microarray or the calculation of a QTL model[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ObservationSet", nullable=false)   	
	
				

	@javax.validation.constraints.NotNull
	private org.molgenis.omx.observ.ObservationSet observationSet = null;
	@javax.persistence.Transient
	private Integer observationSet_id = null;	
	@javax.persistence.Transient
	private String observationSet_Identifier = null;						

	//References the ObservableFeature that this observation was made on. For example 'probe123'.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Feature", nullable=false)   	
	
				

	@javax.validation.constraints.NotNull
	private org.molgenis.omx.observ.ObservableFeature feature = null;
	@javax.persistence.Transient
	private Integer feature_id = null;	
	@javax.persistence.Transient
	private String feature_Identifier = null;						

	//The value observed[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Value")   	
	
				

	private org.molgenis.omx.observ.value.Value value = null;
	@javax.persistence.Transient
	private Integer value_id = null;	

	//constructors
	public ObservedValue()
	{
	}
	
	/** copy constructor */
	public ObservedValue(ObservedValue copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the automatically generated internal id, only for internal use..
	 * @return id.
	 */
	public Integer getId()
	{
		return this.id;
	}
	
	
	/**
	 * Set the automatically generated internal id, only for internal use..
	 * @param id
	 */
	public void setId( Integer id)
	{
		this.id = id;
	}

	

	/**
	 * Get the Reference to the observation. For example a particular patient visit or the application of a microarray or the calculation of a QTL model.
	 * @return observationSet.
	 */
	public org.molgenis.omx.observ.ObservationSet getObservationSet()
	{
		return this.observationSet;
	}
	
	@Deprecated
	public org.molgenis.omx.observ.ObservationSet getObservationSet(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Reference to the observation. For example a particular patient visit or the application of a microarray or the calculation of a QTL model.
	 * @param observationSet
	 */
	public void setObservationSet( org.molgenis.omx.observ.ObservationSet observationSet)
	{
		
		this.observationSet = observationSet;
	}

	
	
	/**
	 * Set foreign key for field observationSet.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setObservationSet_Id(Integer observationSet_id)
	{
		this.observationSet_id = observationSet_id;
	}	

	public void setObservationSet(Integer observationSet_id)
	{
		this.observationSet_id = observationSet_id;
	}
	
	public Integer getObservationSet_Id()
	{
		
		if(observationSet != null) 
		{
			return observationSet.getId();
		}
		else
		{
			return observationSet_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference ObservationSet to ObservationSet.Id.
	 */
	public String getObservationSet_Identifier()
	{		
		//FIXME should we auto-load based on getObservationSet()?	
		if(observationSet != null) {
			return observationSet.getIdentifier();
		} else {
			return observationSet_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference ObservationSet to <a href="ObservationSet.html#Id">ObservationSet.Id</a>.
	 * Implies setObservationSet(null) until save
	 */
	public void setObservationSet_Identifier(String observationSet_Identifier)
	{
		this.observationSet_Identifier = observationSet_Identifier;
	}		
	 
	

	/**
	 * Get the References the ObservableFeature that this observation was made on. For example 'probe123'..
	 * @return feature.
	 */
	public org.molgenis.omx.observ.ObservableFeature getFeature()
	{
		return this.feature;
	}
	
	@Deprecated
	public org.molgenis.omx.observ.ObservableFeature getFeature(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the References the ObservableFeature that this observation was made on. For example 'probe123'..
	 * @param feature
	 */
	public void setFeature( org.molgenis.omx.observ.ObservableFeature feature)
	{
		
		this.feature = feature;
	}

	
	
	/**
	 * Set foreign key for field feature.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setFeature_Id(Integer feature_id)
	{
		this.feature_id = feature_id;
	}	

	public void setFeature(Integer feature_id)
	{
		this.feature_id = feature_id;
	}
	
	public Integer getFeature_Id()
	{
		
		if(feature != null) 
		{
			return feature.getId();
		}
		else
		{
			return feature_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference Feature to ObservableFeature.Id.
	 */
	public String getFeature_Identifier()
	{		
		//FIXME should we auto-load based on getFeature()?	
		if(feature != null) {
			return feature.getIdentifier();
		} else {
			return feature_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Feature to <a href="ObservableFeature.html#Id">ObservableFeature.Id</a>.
	 * Implies setFeature(null) until save
	 */
	public void setFeature_Identifier(String feature_Identifier)
	{
		this.feature_Identifier = feature_Identifier;
	}		
	 
	

	/**
	 * Get the The value observed.
	 * @return value.
	 */
	public org.molgenis.omx.observ.value.Value getValue()
	{
		return this.value;
	}
	
	@Deprecated
	public org.molgenis.omx.observ.value.Value getValue(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The value observed.
	 * @param value
	 */
	public void setValue( org.molgenis.omx.observ.value.Value value)
	{
		
		this.value = value;
	}

	
	
	/**
	 * Set foreign key for field value.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setValue_Id(Integer value_id)
	{
		this.value_id = value_id;
	}	

	public void setValue(Integer value_id)
	{
		this.value_id = value_id;
	}
	
	public Integer getValue_Id()
	{
		
		if(value != null) 
		{
			return value.getId();
		}
		else
		{
			return value_id;
		}
	}	
	 
	 
	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("observationset"))
			return getObservationSet();
		if(name.equals("observationset_id"))
			return getObservationSet_Id();
		if(name.equals("observationset_identifier"))
			return getObservationSet_Identifier();
		if (name.equals("feature"))
			return getFeature();
		if(name.equals("feature_id"))
			return getFeature_Id();
		if(name.equals("feature_identifier"))
			return getFeature_Identifier();
		if (name.equals("value"))
			return getValue();
		if(name.equals("value_id"))
			return getValue_Id();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getObservationSet() == null) throw new org.molgenis.framework.db.DatabaseException("required field observationSet is null");
		if(this.getFeature() == null) throw new org.molgenis.framework.db.DatabaseException("required field feature is null");
	}
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("observedvalue_id") != null) this.setId(entity.getInt("observedvalue_id"));
		else if( entity.getInt("ObservedValue_id") != null) this.setId(entity.getInt("ObservedValue_id"));
		//set ObservationSet
		// query formal name, else lowercase name
		if(entity.getInt("ObservationSet_id") != null) this.setObservationSet(entity.getInt("ObservationSet_id"));
		else if(entity.getInt("observationset_id") != null) this.setObservationSet(entity.getInt("observationset_id"));
		else if(strict) this.setObservationSet(entity.getInt("ObservationSet_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("ObservedValue_ObservationSet_id") != null) this.setObservationSet(entity.getInt("ObservedValue_ObservationSet_id"));
		else if( entity.getInt("observedvalue_observationset_id") != null) this.setObservationSet(entity.getInt("observedvalue_observationset_id"));
		//alias of xref
		if( entity.get("ObservationSet") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("ObservationSet").toString())) {
				org.molgenis.omx.observ.ObservationSet instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("ObservationSet"), org.molgenis.omx.observ.ObservationSet.class);
				this.setObservationSet(instance);				
			} else {
				this.setObservationSet_Id(entity.getInt("ObservationSet")); 
			}
		}
		else if( entity.get("observationset") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("observationset").toString())) {
				org.molgenis.omx.observ.ObservationSet instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("observationset"), org.molgenis.omx.observ.ObservationSet.class);
				this.setObservationSet(instance);				
			} else {
				this.setObservationSet_Id(entity.getInt("ObservationSet"));
			}
		}
		if( entity.get("ObservedValue_ObservationSet") != null)
			this.setObservationSet_Id(entity.getInt("ObservedValue_ObservationSet"));			
		else if( entity.get("observedvalue_observationset") != null)
			this.setObservationSet_Id(entity.getInt("observedvalue_observationset"));
			
		if( entity.get("ObservedValue.ObservationSet") != null) 
			this.setObservationSet((org.molgenis.omx.observ.ObservationSet)entity.get("ObservedValue.ObservationSet_id"));
		else if( entity.get("observedvalue.observationset") != null) 
			this.setObservationSet((org.molgenis.omx.observ.ObservationSet)entity.get("observedvalue.observationset_id"));	
		//set label for field ObservationSet
		if(entity.get("ObservationSet_Identifier") != null) this.setObservationSet_Identifier(entity.getString("ObservationSet_Identifier"));
		else if(entity.get("observationset_identifier") != null) this.setObservationSet_Identifier(entity.getString("observationset_identifier"));
		else if(strict) this.setObservationSet_Identifier(entity.getString("ObservationSet_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("ObservedValue_ObservationSet_Identifier") != null ) this.setObservationSet_Identifier(entity.getString("ObservedValue_ObservationSet_Identifier"));		
		else if( entity.get("observedvalue_observationset_identifier") != null ) this.setObservationSet_Identifier(entity.getString("observedvalue_observationset_identifier"));
		//set Feature
		// query formal name, else lowercase name
		if(entity.getInt("Feature_id") != null) this.setFeature(entity.getInt("Feature_id"));
		else if(entity.getInt("feature_id") != null) this.setFeature(entity.getInt("feature_id"));
		else if(strict) this.setFeature(entity.getInt("Feature_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("ObservedValue_Feature_id") != null) this.setFeature(entity.getInt("ObservedValue_Feature_id"));
		else if( entity.getInt("observedvalue_feature_id") != null) this.setFeature(entity.getInt("observedvalue_feature_id"));
		//alias of xref
		if( entity.get("Feature") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("Feature").toString())) {
				org.molgenis.omx.observ.ObservableFeature instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("Feature"), org.molgenis.omx.observ.ObservableFeature.class);
				this.setFeature(instance);				
			} else {
				this.setFeature_Id(entity.getInt("Feature")); 
			}
		}
		else if( entity.get("feature") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("feature").toString())) {
				org.molgenis.omx.observ.ObservableFeature instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("feature"), org.molgenis.omx.observ.ObservableFeature.class);
				this.setFeature(instance);				
			} else {
				this.setFeature_Id(entity.getInt("Feature"));
			}
		}
		if( entity.get("ObservedValue_Feature") != null)
			this.setFeature_Id(entity.getInt("ObservedValue_Feature"));			
		else if( entity.get("observedvalue_feature") != null)
			this.setFeature_Id(entity.getInt("observedvalue_feature"));
			
		if( entity.get("ObservedValue.Feature") != null) 
			this.setFeature((org.molgenis.omx.observ.ObservableFeature)entity.get("ObservedValue.Feature_id"));
		else if( entity.get("observedvalue.feature") != null) 
			this.setFeature((org.molgenis.omx.observ.ObservableFeature)entity.get("observedvalue.feature_id"));	
		//set label for field Feature
		if(entity.get("Feature_Identifier") != null) this.setFeature_Identifier(entity.getString("Feature_Identifier"));
		else if(entity.get("feature_identifier") != null) this.setFeature_Identifier(entity.getString("feature_identifier"));
		else if(strict) this.setFeature_Identifier(entity.getString("Feature_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("ObservedValue_Feature_Identifier") != null ) this.setFeature_Identifier(entity.getString("ObservedValue_Feature_Identifier"));		
		else if( entity.get("observedvalue_feature_identifier") != null ) this.setFeature_Identifier(entity.getString("observedvalue_feature_identifier"));
		//set Value
		// query formal name, else lowercase name
		if(entity.getInt("Value_id") != null) this.setValue(entity.getInt("Value_id"));
		else if(entity.getInt("value_id") != null) this.setValue(entity.getInt("value_id"));
		else if(strict) this.setValue(entity.getInt("Value_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("ObservedValue_Value_id") != null) this.setValue(entity.getInt("ObservedValue_Value_id"));
		else if( entity.getInt("observedvalue_value_id") != null) this.setValue(entity.getInt("observedvalue_value_id"));
		//alias of xref
		if( entity.get("Value") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("Value").toString())) {
				org.molgenis.omx.observ.value.Value instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("Value"), org.molgenis.omx.observ.value.Value.class);
				this.setValue(instance);				
			} else {
				this.setValue_Id(entity.getInt("Value")); 
			}
		}
		else if( entity.get("value") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("value").toString())) {
				org.molgenis.omx.observ.value.Value instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("value"), org.molgenis.omx.observ.value.Value.class);
				this.setValue(instance);				
			} else {
				this.setValue_Id(entity.getInt("Value"));
			}
		}
		if( entity.get("ObservedValue_Value") != null)
			this.setValue_Id(entity.getInt("ObservedValue_Value"));			
		else if( entity.get("observedvalue_value") != null)
			this.setValue_Id(entity.getInt("observedvalue_value"));
			
		if( entity.get("ObservedValue.Value") != null) 
			this.setValue((org.molgenis.omx.observ.value.Value)entity.get("ObservedValue.Value_id"));
		else if( entity.get("observedvalue.value") != null) 
			this.setValue((org.molgenis.omx.observ.value.Value)entity.get("observedvalue.value_id"));	
		//set label for field Value
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "ObservedValue(";
		result+= "id='" + getId()+"' ";	
		result+= " observationSet_id='" + getObservationSet_Id()+"' ";	
		result+= " observationSet_identifier='" + getObservationSet_Identifier()+"' ";
		result+= " feature_id='" + getFeature_Id()+"' ";	
		result+= " feature_identifier='" + getFeature_Identifier()+"' ";
		result+= " value_id='" + getValue_Id()+"' ";	
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of ObservedValue.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("ObservationSet_id");
		}
		fields.add("ObservationSet_Identifier");
		{
			fields.add("Feature_id");
		}
		fields.add("Feature_Identifier");
		{
			fields.add("Value_id");
		}
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("id");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "observationSet" +sep
		+ "feature" +sep
		+ "value" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("observationSet")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("feature")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("value")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getObservationSet();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getFeature();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getValue();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public ObservedValue create(org.molgenis.data.Entity entity) throws Exception
	{
		ObservedValue e = new ObservedValue();
		e.set(entity);
		return e;
	}
	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = 1;
		return result;
	}
}
