
/* File:        org.molgenis.omx/model/Protocol.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ;

/**
 * Protocol: 
				The Protocol class defines parameterizable descriptions of
				(analysis)methods. Examples of protocols are: Questionaires, SOPs,
				Assay platforms, Statistical analyses, etc.
				Each protocol has a unique identifier.
				Protocol has an association to OntologyTerm to
				represent the type of protocol.
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "Protocol"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.observ.db.ProtocolEntityListener.class})
public class Protocol extends org.molgenis.omx.observ.Characteristic 
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String PROTOCOLTYPE = "ProtocolType";
	public final static String PROTOCOLTYPE_IDENTIFIER = "ProtocolType_Identifier";
	public final static String SUBPROTOCOLS = "subprotocols";
	public final static String SUBPROTOCOLS_IDENTIFIER = "subprotocols_Identifier";
	public final static String FEATURES = "Features";
	public final static String FEATURES_IDENTIFIER = "Features_Identifier";
	public final static String REQUIREDFEATURES = "RequiredFeatures";
	public final static String REQUIREDFEATURES_IDENTIFIER = "RequiredFeatures_Identifier";
	public final static String ROOT = "root";
	public final static String ID = "id";
	
	//static methods
	/**
	 * Shorthand for db.query(Protocol.class).
	 */
	public static org.molgenis.framework.db.Query<? extends Protocol> query(org.molgenis.framework.db.Database db)
	{
		return db.query(Protocol.class);
	}
	
	/**
	 * Shorthand for db.find(Protocol.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends Protocol> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(Protocol.class, rules);
	}	
	
	/**
	 * 
	 */
	public static Protocol findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Protocol> q = db.query(Protocol.class);
		q = q.eq(Protocol.ID, id);
		java.util.List<Protocol> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static Protocol findByIdentifier(org.molgenis.framework.db.Database db, String identifier) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Protocol> q = db.query(Protocol.class);
		q = q.eq(Protocol.IDENTIFIER, identifier);
		java.util.List<Protocol> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//classification of protocol[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ProtocolType")   	
	
				

	private org.molgenis.omx.observ.target.OntologyTerm protocolType = null;
	@javax.persistence.Transient
	private Integer protocolType_id = null;	
	@javax.persistence.Transient
	private String protocolType_Identifier = null;						

	//Subprotocols of this protocol[type=mref]
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="subprotocols", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="Protocol_subprotocols", 
			joinColumns=@javax.persistence.JoinColumn(name="Protocol"), inverseJoinColumns=@javax.persistence.JoinColumn(name="subprotocols"))
	
				

	private java.util.List<org.molgenis.omx.observ.Protocol> subprotocols = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>();
	@javax.persistence.Transient
	private java.util.List<Integer> subprotocols_id = new java.util.ArrayList<Integer>();		
	@javax.persistence.Transient
	private java.util.List<String> subprotocols_Identifier = new java.util.ArrayList<String>();

	//parameters (in/out) that are used or produced by this protocol.[type=mref]
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Features", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="Protocol_Features", 
			joinColumns=@javax.persistence.JoinColumn(name="Protocol"), inverseJoinColumns=@javax.persistence.JoinColumn(name="Features"))
	
				

	private java.util.List<org.molgenis.omx.observ.ObservableFeature> features = new java.util.ArrayList<org.molgenis.omx.observ.ObservableFeature>();
	@javax.persistence.Transient
	private java.util.List<Integer> features_id = new java.util.ArrayList<Integer>();		
	@javax.persistence.Transient
	private java.util.List<String> features_Identifier = new java.util.ArrayList<String>();

	//..........[type=mref]
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="RequiredFeatures", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="Protocol_RequiredFeatures", 
			joinColumns=@javax.persistence.JoinColumn(name="Protocol"), inverseJoinColumns=@javax.persistence.JoinColumn(name="RequiredFeatures"))
	
				

	private java.util.List<org.molgenis.omx.observ.ObservableFeature> requiredFeatures = new java.util.ArrayList<org.molgenis.omx.observ.ObservableFeature>();
	@javax.persistence.Transient
	private java.util.List<Integer> requiredFeatures_id = new java.util.ArrayList<Integer>();		
	@javax.persistence.Transient
	private java.util.List<String> requiredFeatures_Identifier = new java.util.ArrayList<String>();

	//Indicator whether this protocol defines a workflow (e.g is the first protocol of a workflow).[type=bool]
	@javax.persistence.Column(name="root", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="root")
	
				

	@javax.validation.constraints.NotNull
	private Boolean root =  false;

	//automatically generated internal id, only for internal use.[type=int]
	

	//constructors
	public Protocol()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	/** copy constructor */
	public Protocol(Protocol copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the classification of protocol.
	 * @return protocolType.
	 */
	public org.molgenis.omx.observ.target.OntologyTerm getProtocolType()
	{
		return this.protocolType;
	}
	
	@Deprecated
	public org.molgenis.omx.observ.target.OntologyTerm getProtocolType(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the classification of protocol.
	 * @param protocolType
	 */
	public void setProtocolType( org.molgenis.omx.observ.target.OntologyTerm protocolType)
	{
		
		this.protocolType = protocolType;
	}

	
	
	/**
	 * Set foreign key for field protocolType.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setProtocolType_Id(Integer protocolType_id)
	{
		this.protocolType_id = protocolType_id;
	}	

	public void setProtocolType(Integer protocolType_id)
	{
		this.protocolType_id = protocolType_id;
	}
	
	public Integer getProtocolType_Id()
	{
		
		if(protocolType != null) 
		{
			return protocolType.getId();
		}
		else
		{
			return protocolType_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference ProtocolType to OntologyTerm.Id.
	 */
	public String getProtocolType_Identifier()
	{		
		//FIXME should we auto-load based on getProtocolType()?	
		if(protocolType != null) {
			return protocolType.getIdentifier();
		} else {
			return protocolType_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference ProtocolType to <a href="OntologyTerm.html#Id">OntologyTerm.Id</a>.
	 * Implies setProtocolType(null) until save
	 */
	public void setProtocolType_Identifier(String protocolType_Identifier)
	{
		this.protocolType_Identifier = protocolType_Identifier;
	}		
	 
	

	/**
	 * Get the Subprotocols of this protocol.
	 * @return subprotocols.
	 */
	public java.util.List<org.molgenis.omx.observ.Protocol> getSubprotocols()
	{
		return this.subprotocols;
	}
	
	@Deprecated
	public java.util.List<org.molgenis.omx.observ.Protocol> getSubprotocols(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Subprotocols of this protocol.
	 * @param subprotocols
	 */
	public void setSubprotocols( java.util.List<org.molgenis.omx.observ.Protocol> subprotocols)
	{
		
		this.subprotocols = subprotocols;
	}

	
	public void setSubprotocols_Id(Integer ... subprotocols)
	{
		this.setSubprotocols_Id(java.util.Arrays.asList(subprotocols));
	}	
	
	public void setSubprotocols(org.molgenis.omx.observ.Protocol ... subprotocols)
	{
		this.setSubprotocols(java.util.Arrays.asList(subprotocols));
	}	
	
	/**
	 * Set foreign key for field subprotocols.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setSubprotocols_Id(java.util.List<Integer> subprotocols_id)
	{
		this.subprotocols_id = subprotocols_id;
	}	
	
	public java.util.List<Integer> getSubprotocols_Id()
	{
		if(subprotocols != null && !subprotocols.isEmpty()) {
			java.util.List<Integer> result = new java.util.ArrayList<Integer>();
			for (int i = 0; i < subprotocols.size(); i++)
				result.add(subprotocols.get(i).getId());
			return result;
		} else {
			if(subprotocols_id == null) {
				subprotocols_id = new java.util.ArrayList<Integer>();
			}		
			return subprotocols_id;
		}
	}	
	
	/**
	 * Get a pretty label for cross reference Subprotocols to <a href="Protocol.html#Id">Protocol.Id</a>.
	 */
	public java.util.List<String> getSubprotocols_Identifier()
	{
		if(this.subprotocols != null && !this.subprotocols.isEmpty())
		{
			java.util.List<String> result = new java.util.ArrayList<String>(this.subprotocols.size());
			for(org.molgenis.omx.observ.Protocol o: subprotocols) result.add(o.getIdentifier());
			return java.util.Collections.unmodifiableList(result);
		}	
		else
		{	
			return subprotocols_Identifier;
		}
	}
	
	/**
	 * Update the foreign key Subprotocols
	 * This sets subprotocols to null until next database transaction.
	 */
	public void setSubprotocols_Identifier(java.util.List<String> subprotocols_Identifier)
	{
		this.subprotocols_Identifier = subprotocols_Identifier;
	}		
	

	/**
	 * Get the parameters (in/out) that are used or produced by this protocol..
	 * @return features.
	 */
	public java.util.List<org.molgenis.omx.observ.ObservableFeature> getFeatures()
	{
		return this.features;
	}
	
	@Deprecated
	public java.util.List<org.molgenis.omx.observ.ObservableFeature> getFeatures(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the parameters (in/out) that are used or produced by this protocol..
	 * @param features
	 */
	public void setFeatures( java.util.List<org.molgenis.omx.observ.ObservableFeature> features)
	{
		
		this.features = features;
	}

	
	public void setFeatures_Id(Integer ... features)
	{
		this.setFeatures_Id(java.util.Arrays.asList(features));
	}	
	
	public void setFeatures(org.molgenis.omx.observ.ObservableFeature ... features)
	{
		this.setFeatures(java.util.Arrays.asList(features));
	}	
	
	/**
	 * Set foreign key for field features.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setFeatures_Id(java.util.List<Integer> features_id)
	{
		this.features_id = features_id;
	}	
	
	public java.util.List<Integer> getFeatures_Id()
	{
		if(features != null && !features.isEmpty()) {
			java.util.List<Integer> result = new java.util.ArrayList<Integer>();
			for (int i = 0; i < features.size(); i++)
				result.add(features.get(i).getId());
			return result;
		} else {
			if(features_id == null) {
				features_id = new java.util.ArrayList<Integer>();
			}		
			return features_id;
		}
	}	
	
	/**
	 * Get a pretty label for cross reference Features to <a href="ObservableFeature.html#Id">ObservableFeature.Id</a>.
	 */
	public java.util.List<String> getFeatures_Identifier()
	{
		if(this.features != null && !this.features.isEmpty())
		{
			java.util.List<String> result = new java.util.ArrayList<String>(this.features.size());
			for(org.molgenis.omx.observ.ObservableFeature o: features) result.add(o.getIdentifier());
			return java.util.Collections.unmodifiableList(result);
		}	
		else
		{	
			return features_Identifier;
		}
	}
	
	/**
	 * Update the foreign key Features
	 * This sets features to null until next database transaction.
	 */
	public void setFeatures_Identifier(java.util.List<String> features_Identifier)
	{
		this.features_Identifier = features_Identifier;
	}		
	

	/**
	 * Get the ...........
	 * @return requiredFeatures.
	 */
	public java.util.List<org.molgenis.omx.observ.ObservableFeature> getRequiredFeatures()
	{
		return this.requiredFeatures;
	}
	
	@Deprecated
	public java.util.List<org.molgenis.omx.observ.ObservableFeature> getRequiredFeatures(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the ...........
	 * @param requiredFeatures
	 */
	public void setRequiredFeatures( java.util.List<org.molgenis.omx.observ.ObservableFeature> requiredFeatures)
	{
		
		this.requiredFeatures = requiredFeatures;
	}

	
	public void setRequiredFeatures_Id(Integer ... requiredFeatures)
	{
		this.setRequiredFeatures_Id(java.util.Arrays.asList(requiredFeatures));
	}	
	
	public void setRequiredFeatures(org.molgenis.omx.observ.ObservableFeature ... requiredFeatures)
	{
		this.setRequiredFeatures(java.util.Arrays.asList(requiredFeatures));
	}	
	
	/**
	 * Set foreign key for field requiredFeatures.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setRequiredFeatures_Id(java.util.List<Integer> requiredFeatures_id)
	{
		this.requiredFeatures_id = requiredFeatures_id;
	}	
	
	public java.util.List<Integer> getRequiredFeatures_Id()
	{
		if(requiredFeatures != null && !requiredFeatures.isEmpty()) {
			java.util.List<Integer> result = new java.util.ArrayList<Integer>();
			for (int i = 0; i < requiredFeatures.size(); i++)
				result.add(requiredFeatures.get(i).getId());
			return result;
		} else {
			if(requiredFeatures_id == null) {
				requiredFeatures_id = new java.util.ArrayList<Integer>();
			}		
			return requiredFeatures_id;
		}
	}	
	
	/**
	 * Get a pretty label for cross reference RequiredFeatures to <a href="ObservableFeature.html#Id">ObservableFeature.Id</a>.
	 */
	public java.util.List<String> getRequiredFeatures_Identifier()
	{
		if(this.requiredFeatures != null && !this.requiredFeatures.isEmpty())
		{
			java.util.List<String> result = new java.util.ArrayList<String>(this.requiredFeatures.size());
			for(org.molgenis.omx.observ.ObservableFeature o: requiredFeatures) result.add(o.getIdentifier());
			return java.util.Collections.unmodifiableList(result);
		}	
		else
		{	
			return requiredFeatures_Identifier;
		}
	}
	
	/**
	 * Update the foreign key RequiredFeatures
	 * This sets requiredFeatures to null until next database transaction.
	 */
	public void setRequiredFeatures_Identifier(java.util.List<String> requiredFeatures_Identifier)
	{
		this.requiredFeatures_Identifier = requiredFeatures_Identifier;
	}		
	

	/**
	 * Get the Indicator whether this protocol defines a workflow (e.g is the first protocol of a workflow)..
	 * @return root.
	 */
	public Boolean getRoot()
	{
		return this.root;
	}
	
	@Deprecated
	public Boolean getRoot(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Indicator whether this protocol defines a workflow (e.g is the first protocol of a workflow)..
	 * @param root
	 */
	public void setRoot( Boolean root)
	{
		
		this.root = root;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();
		if (name.equals("description"))
			return getDescription();
		if (name.equals("protocoltype"))
			return getProtocolType();
		if(name.equals("protocoltype_id"))
			return getProtocolType_Id();
		if(name.equals("protocoltype_identifier"))
			return getProtocolType_Identifier();
		if (name.equals("subprotocols"))
			return getSubprotocols();
		if(name.equals("subprotocols_id"))
			return getSubprotocols_Id();
		if(name.equals("subprotocols_identifier"))
			return getSubprotocols_Identifier();
		if (name.equals("features"))
			return getFeatures();
		if(name.equals("features_id"))
			return getFeatures_Id();
		if(name.equals("features_identifier"))
			return getFeatures_Identifier();
		if (name.equals("requiredfeatures"))
			return getRequiredFeatures();
		if(name.equals("requiredfeatures_id"))
			return getRequiredFeatures_Id();
		if(name.equals("requiredfeatures_identifier"))
			return getRequiredFeatures_Identifier();
		if (name.equals("root"))
			return getRoot();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getIdentifier() == null) throw new org.molgenis.framework.db.DatabaseException("required field identifier is null");
		if(this.getName() == null) throw new org.molgenis.framework.db.DatabaseException("required field name is null");
		if(this.get__Type() == null) throw new org.molgenis.framework.db.DatabaseException("required field __Type is null");
		if(this.getRoot() == null) throw new org.molgenis.framework.db.DatabaseException("required field root is null");
	}
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("protocol_id") != null) this.setId(entity.getInt("protocol_id"));
		else if( entity.getInt("Protocol_id") != null) this.setId(entity.getInt("Protocol_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("protocol_identifier") != null) this.setIdentifier(entity.getString("protocol_identifier"));
		else if( entity.getString("Protocol_Identifier") != null) this.setIdentifier(entity.getString("Protocol_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("protocol_name") != null) this.setName(entity.getString("protocol_name"));
		else if( entity.getString("Protocol_Name") != null) this.setName(entity.getString("Protocol_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("protocol___type") != null) this.set__Type(entity.getString("protocol___type"));
		else if( entity.getString("Protocol___Type") != null) this.set__Type(entity.getString("Protocol___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("protocol_description") != null) this.setDescription(entity.getString("protocol_description"));
		else if( entity.getString("Protocol_description") != null) this.setDescription(entity.getString("Protocol_description"));
		//set ProtocolType
		// query formal name, else lowercase name
		if(entity.getInt("ProtocolType_id") != null) this.setProtocolType(entity.getInt("ProtocolType_id"));
		else if(entity.getInt("protocoltype_id") != null) this.setProtocolType(entity.getInt("protocoltype_id"));
		else if(strict) this.setProtocolType(entity.getInt("ProtocolType_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("Protocol_ProtocolType_id") != null) this.setProtocolType(entity.getInt("Protocol_ProtocolType_id"));
		else if( entity.getInt("protocol_protocoltype_id") != null) this.setProtocolType(entity.getInt("protocol_protocoltype_id"));
		//alias of xref
		if( entity.get("ProtocolType") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("ProtocolType").toString())) {
				org.molgenis.omx.observ.target.OntologyTerm instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("ProtocolType"), org.molgenis.omx.observ.target.OntologyTerm.class);
				this.setProtocolType(instance);				
			} else {
				this.setProtocolType_Id(entity.getInt("ProtocolType")); 
			}
		}
		else if( entity.get("protocoltype") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("protocoltype").toString())) {
				org.molgenis.omx.observ.target.OntologyTerm instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("protocoltype"), org.molgenis.omx.observ.target.OntologyTerm.class);
				this.setProtocolType(instance);				
			} else {
				this.setProtocolType_Id(entity.getInt("ProtocolType"));
			}
		}
		if( entity.get("Protocol_ProtocolType") != null)
			this.setProtocolType_Id(entity.getInt("Protocol_ProtocolType"));			
		else if( entity.get("protocol_protocoltype") != null)
			this.setProtocolType_Id(entity.getInt("protocol_protocoltype"));
			
		if( entity.get("Protocol.ProtocolType") != null) 
			this.setProtocolType((org.molgenis.omx.observ.target.OntologyTerm)entity.get("Protocol.ProtocolType_id"));
		else if( entity.get("protocol.protocoltype") != null) 
			this.setProtocolType((org.molgenis.omx.observ.target.OntologyTerm)entity.get("protocol.protocoltype_id"));	
		//set label for field ProtocolType
		if(entity.get("ProtocolType_Identifier") != null) this.setProtocolType_Identifier(entity.getString("ProtocolType_Identifier"));
		else if(entity.get("protocoltype_identifier") != null) this.setProtocolType_Identifier(entity.getString("protocoltype_identifier"));
		else if(strict) this.setProtocolType_Identifier(entity.getString("ProtocolType_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("Protocol_ProtocolType_Identifier") != null ) this.setProtocolType_Identifier(entity.getString("Protocol_ProtocolType_Identifier"));		
		else if( entity.get("protocol_protocoltype_identifier") != null ) this.setProtocolType_Identifier(entity.getString("protocol_protocoltype_identifier"));
		//set Subprotocols
		if( entity.get("subprotocols") != null || entity.get("Protocol_subprotocols") != null || entity.get("subprotocols") != null || entity.get("protocol_subprotocols") != null) 
		{
			java.util.List<Integer> values = new java.util.ArrayList<Integer>();
			java.util.List<?> mrefs = entity.getList("subprotocols");
			if(mrefs == null) mrefs = entity.getList("subprotocols");
			if(entity.get("protocol_subprotocols")!= null) mrefs = entity.getList("protocol_subprotocols");
			else if(entity.get("Protocol_subprotocols")!= null) mrefs = entity.getList("Protocol_subprotocols");
			if(mrefs != null) for(Object ref: mrefs)
			{
				if(ref instanceof String)
					values.add(Integer.parseInt((String)ref));
				else if(ref instanceof org.molgenis.util.AbstractEntity) 	
					values.add((Integer)((org.molgenis.util.AbstractEntity)ref).getIdValue() );
				else
					values.add((Integer)ref);		
			}											
			this.setSubprotocols_Id( values );
		}
		//set labels Identifier for mref field Subprotocols	
		if( entity.get("subprotocols_Identifier") != null || entity.get("Protocol_subprotocols_Identifier")!= null || entity.get("subprotocols_identifier") != null || entity.get("protocol_subprotocols_identifier") != null) 
		{
			java.util.List<String> values = new java.util.ArrayList<String>();
			java.util.List<?> mrefs = entity.getList("subprotocols_Identifier");
			if(mrefs == null) mrefs = entity.getList("subprotocols_identifier");
			if(entity.get("Protocol_subprotocols_Identifier")!= null) mrefs = entity.getList("Protocol_subprotocols_Identifier");
			else if(entity.get("protocol_subprotocols_identifier")!= null) mrefs = entity.getList("protocol_subprotocols_identifier");
			if(mrefs != null) 
				for(Object ref: mrefs)
				{
					String[] refs = ref.toString().split("\\|");
					for(String r : refs) {
						values.add(r);	
					}						
				}							
			this.setSubprotocols_Identifier( values );			
		}	
		//set Features
		if( entity.get("Features") != null || entity.get("Protocol_Features") != null || entity.get("features") != null || entity.get("protocol_features") != null) 
		{
			java.util.List<Integer> values = new java.util.ArrayList<Integer>();
			java.util.List<?> mrefs = entity.getList("Features");
			if(mrefs == null) mrefs = entity.getList("features");
			if(entity.get("protocol_features")!= null) mrefs = entity.getList("protocol_features");
			else if(entity.get("Protocol_Features")!= null) mrefs = entity.getList("Protocol_Features");
			if(mrefs != null) for(Object ref: mrefs)
			{
				if(ref instanceof String)
					values.add(Integer.parseInt((String)ref));
				else if(ref instanceof org.molgenis.util.AbstractEntity) 	
					values.add((Integer)((org.molgenis.util.AbstractEntity)ref).getIdValue() );
				else
					values.add((Integer)ref);		
			}											
			this.setFeatures_Id( values );
		}
		//set labels Identifier for mref field Features	
		if( entity.get("Features_Identifier") != null || entity.get("Protocol_Features_Identifier")!= null || entity.get("features_identifier") != null || entity.get("protocol_features_identifier") != null) 
		{
			java.util.List<String> values = new java.util.ArrayList<String>();
			java.util.List<?> mrefs = entity.getList("Features_Identifier");
			if(mrefs == null) mrefs = entity.getList("features_identifier");
			if(entity.get("Protocol_Features_Identifier")!= null) mrefs = entity.getList("Protocol_Features_Identifier");
			else if(entity.get("protocol_features_identifier")!= null) mrefs = entity.getList("protocol_features_identifier");
			if(mrefs != null) 
				for(Object ref: mrefs)
				{
					String[] refs = ref.toString().split("\\|");
					for(String r : refs) {
						values.add(r);	
					}						
				}							
			this.setFeatures_Identifier( values );			
		}	
		//set RequiredFeatures
		if( entity.get("RequiredFeatures") != null || entity.get("Protocol_RequiredFeatures") != null || entity.get("requiredfeatures") != null || entity.get("protocol_requiredfeatures") != null) 
		{
			java.util.List<Integer> values = new java.util.ArrayList<Integer>();
			java.util.List<?> mrefs = entity.getList("RequiredFeatures");
			if(mrefs == null) mrefs = entity.getList("requiredfeatures");
			if(entity.get("protocol_requiredfeatures")!= null) mrefs = entity.getList("protocol_requiredfeatures");
			else if(entity.get("Protocol_RequiredFeatures")!= null) mrefs = entity.getList("Protocol_RequiredFeatures");
			if(mrefs != null) for(Object ref: mrefs)
			{
				if(ref instanceof String)
					values.add(Integer.parseInt((String)ref));
				else if(ref instanceof org.molgenis.util.AbstractEntity) 	
					values.add((Integer)((org.molgenis.util.AbstractEntity)ref).getIdValue() );
				else
					values.add((Integer)ref);		
			}											
			this.setRequiredFeatures_Id( values );
		}
		//set labels Identifier for mref field RequiredFeatures	
		if( entity.get("RequiredFeatures_Identifier") != null || entity.get("Protocol_RequiredFeatures_Identifier")!= null || entity.get("requiredfeatures_identifier") != null || entity.get("protocol_requiredfeatures_identifier") != null) 
		{
			java.util.List<String> values = new java.util.ArrayList<String>();
			java.util.List<?> mrefs = entity.getList("RequiredFeatures_Identifier");
			if(mrefs == null) mrefs = entity.getList("requiredfeatures_identifier");
			if(entity.get("Protocol_RequiredFeatures_Identifier")!= null) mrefs = entity.getList("Protocol_RequiredFeatures_Identifier");
			else if(entity.get("protocol_requiredfeatures_identifier")!= null) mrefs = entity.getList("protocol_requiredfeatures_identifier");
			if(mrefs != null) 
				for(Object ref: mrefs)
				{
					String[] refs = ref.toString().split("\\|");
					for(String r : refs) {
						values.add(r);	
					}						
				}							
			this.setRequiredFeatures_Identifier( values );			
		}	
		//set Root
		// query formal name, else lowercase name
		if(entity.getBoolean("root") != null) this.setRoot(entity.getBoolean("root"));
		else if(entity.getBoolean("root") != null) this.setRoot(entity.getBoolean("root"));
		else if(strict) this.setRoot(entity.getBoolean("root")); // setting null is not an option due to function overloading
		if( entity.getBoolean("protocol_root") != null) this.setRoot(entity.getBoolean("protocol_root"));
		else if( entity.getBoolean("Protocol_root") != null) this.setRoot(entity.getBoolean("Protocol_root"));
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "Protocol(";
		result+= "id='" + getId()+"' ";	
		result+= "identifier='" + getIdentifier()+"' ";	
		result+= "name='" + getName()+"' ";	
		result+= "__Type='" + get__Type()+"' ";	
		result+= "description='" + getDescription()+"' ";	
		result+= " protocolType_id='" + getProtocolType_Id()+"' ";	
		result+= " protocolType_identifier='" + getProtocolType_Identifier()+"' ";
		result+= " subprotocols_id='" + getSubprotocols_Id()+"' ";	
		result+= " subprotocols_identifier='" + getSubprotocols_Identifier()+"' ";
		result+= " features_id='" + getFeatures_Id()+"' ";	
		result+= " features_identifier='" + getFeatures_Identifier()+"' ";
		result+= " requiredFeatures_id='" + getRequiredFeatures_Id()+"' ";	
		result+= " requiredFeatures_identifier='" + getRequiredFeatures_Identifier()+"' ";
		result+= "root='" + getRoot()+"'";	
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of Protocol.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Identifier");
		}
		{
			fields.add("Name");
		}
		{
			fields.add("__Type");
		}
		{
			fields.add("description");
		}
		{
			fields.add("ProtocolType_id");
		}
		fields.add("ProtocolType_Identifier");
		{
			fields.add("subprotocols_id");
		}
		fields.add("subprotocols_Identifier");
		{
			fields.add("Features_id");
		}
		fields.add("Features_Identifier");
		{
			fields.add("RequiredFeatures_id");
		}
		fields.add("RequiredFeatures_Identifier");
		{
			fields.add("root");
		}
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "identifier" +sep
		+ "name" +sep
		+ "__Type" +sep
		+ "description" +sep
		+ "protocolType" +sep
		+ "subprotocols" +sep
		+ "features" +sep
		+ "requiredFeatures" +sep
		+ "root" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("protocolType")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("subprotocols")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("features")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("requiredFeatures")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdentifier();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = get__Type();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDescription();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getProtocolType();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSubprotocols();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getFeatures();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getRequiredFeatures();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getRoot();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public Protocol create(org.molgenis.data.Entity entity) throws Exception
	{
		Protocol e = new Protocol();
		e.set(entity);
		return e;
	}
	
	//6
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY, mappedBy="subprotocols"/*, cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    private java.util.Collection<org.molgenis.omx.observ.Protocol> subprotocolsProtocolCollection;

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.observ.Protocol> getSubprotocolsProtocolCollection()
	{
		if(subprotocolsProtocolCollection == null) subprotocolsProtocolCollection = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>(); 
        return subprotocolsProtocolCollection;
	}

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.observ.Protocol> getSubprotocolsProtocolCollection(org.molgenis.framework.db.Database db)
	{
        return getSubprotocolsProtocolCollection();
	}

    public void setSubprotocolsProtocolCollection(java.util.Collection<org.molgenis.omx.observ.Protocol> collection)
    {
		if(subprotocolsProtocolCollection == null) subprotocolsProtocolCollection = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>();
    	subprotocolsProtocolCollection.addAll(collection);
    }	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
}
