
/* File:        org.molgenis.omx/model/ObservedValue.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.ObservationSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.value.Value;
import org.molgenis.omx.observ.ObservedValue;


/**
 * Reads ObservedValue from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class ObservedValueEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(ObservedValueEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'observationSet' (maps observationSet.Identifier -> observationSet.id)			
	final Map<String,Integer> observationSetKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'feature' (maps observableFeature.Identifier -> observableFeature.id)			
	final Map<String,Integer> featureKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports ObservedValue from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<ObservedValue> observedValuesMissingRefs = new ArrayList<ObservedValue>();
	
		//cache for objects to be imported from file (in batch)
		final List<ObservedValue> observedValueList = new ArrayList<ObservedValue>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			ObservedValue object = new ObservedValue();
			object.set(entity, false);				
			observedValueList.add(object);		
			
			//add to db when batch size is reached
			if(observedValueList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				observedValuesMissingRefs.addAll(resolveForeignKeys(db, observedValueList));
				observedValueList.removeAll(observedValuesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
				db.update(observedValueList,dbAction, "id");
				
				//clear for next batch						
				observedValueList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!observedValueList.isEmpty())
		{
			total.set(total.get() + observedValueList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			observedValuesMissingRefs.addAll(resolveForeignKeys(db, observedValueList));
			observedValueList.removeAll(observedValuesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
			db.update(observedValueList,dbAction, "id");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<ObservedValue> observedValues = new ArrayList<ObservedValue>(observedValuesMissingRefs);

		int iterationCount = 0;

		do
		{
			observedValuesMissingRefs = resolveForeignKeys(db, observedValuesMissingRefs);
			
			LinkedHashSet<ObservedValue> differenceSet = new LinkedHashSet<ObservedValue>();
			Sets.symmetricDifference(new LinkedHashSet<ObservedValue>(observedValues), new LinkedHashSet<ObservedValue>(observedValuesMissingRefs)).copyInto(differenceSet);
			List<ObservedValue> resolvableobservedValues = new ArrayList<ObservedValue>(differenceSet);
			
			observedValues.removeAll(resolvableobservedValues);
			
			db.update(resolvableobservedValues,dbAction, "id");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(ObservedValue blaat : observedValuesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'observedValue' entity failed:"
								+ "This is probably caused by a(n) 'observedValue' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (observedValuesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " observedValue from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param observedValueList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<ObservedValue> resolveForeignKeys(Database db, List<ObservedValue> observedValueList) throws Exception
	{
		//keep a list of ObservedValue instances that miss a reference which might be resolvable later
		List<ObservedValue> observedValuesMissingRefs = new ArrayList<ObservedValue>();
	
		//resolve xref 'observationSet' from observationSet.Identifier -> observationSet.id
		for(ObservedValue o: observedValueList) 
		{
			if(o.getObservationSet_Identifier() != null) 
				observationSetKeymap.put(o.getObservationSet_Identifier(), null);
		}
		
		if(observationSetKeymap.size() > 0) 
		{
			List<ObservationSet> observationSetList = db.query(ObservationSet.class).in("Identifier",new ArrayList<Object>(observationSetKeymap.keySet())).find();
			for(ObservationSet xref :  observationSetList)
			{
				observationSetKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'feature' from observableFeature.Identifier -> observableFeature.id
		for(ObservedValue o: observedValueList) 
		{
			if(o.getFeature_Identifier() != null) 
				featureKeymap.put(o.getFeature_Identifier(), null);
		}
		
		if(featureKeymap.size() > 0) 
		{
			List<ObservableFeature> featureList = db.query(ObservableFeature.class).in("Identifier",new ArrayList<Object>(featureKeymap.keySet())).find();
			for(ObservableFeature xref :  featureList)
			{
				featureKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(ObservedValue o:  observedValueList)
		{
			while(true){
				//update xref ObservationSet
				if(o.getObservationSet_Identifier() != null) 
				{
					String key = o.getObservationSet_Identifier();
					if(observationSetKeymap.get(key) == null)
					{
						throw new Exception("Import of 'ObservedValue' objects failed: cannot find ObservationSet for observationSet_Identifier='"+o.getObservationSet_Identifier()+"'");
					}
					o.setObservationSet_Id(observationSetKeymap.get(key));
				}
				//update xref Feature
				if(o.getFeature_Identifier() != null) 
				{
					String key = o.getFeature_Identifier();
					if(featureKeymap.get(key) == null)
					{
						throw new Exception("Import of 'ObservedValue' objects failed: cannot find ObservableFeature for feature_Identifier='"+o.getFeature_Identifier()+"'");
					}
					o.setFeature_Id(featureKeymap.get(key));
				}
				break;
			}
		}
		
		observationSetKeymap.clear();
		featureKeymap.clear();
		
		return observedValuesMissingRefs;
	}
}

