
/* File:        org.molgenis.omx/model/Protocol_RequiredFeatures.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.Protocol;
import org.molgenis.omx.observ.Protocol_RequiredFeatures;


/**
 * Reads Protocol_RequiredFeatures from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class Protocol_RequiredFeaturesEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(Protocol_RequiredFeaturesEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'requiredFeatures' (maps observableFeature.Identifier -> observableFeature.id)			
	final Map<String,Integer> requiredFeaturesKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'protocol' (maps protocol.Identifier -> protocol.id)			
	final Map<String,Integer> protocolKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Protocol_RequiredFeatures from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Protocol_RequiredFeatures> protocol_RequiredFeaturessMissingRefs = new ArrayList<Protocol_RequiredFeatures>();
	
		//cache for objects to be imported from file (in batch)
		final List<Protocol_RequiredFeatures> protocol_RequiredFeaturesList = new ArrayList<Protocol_RequiredFeatures>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Protocol_RequiredFeatures object = new Protocol_RequiredFeatures();
			object.set(entity, false);				
			protocol_RequiredFeaturesList.add(object);		
			
			//add to db when batch size is reached
			if(protocol_RequiredFeaturesList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				protocol_RequiredFeaturessMissingRefs.addAll(resolveForeignKeys(db, protocol_RequiredFeaturesList));
				protocol_RequiredFeaturesList.removeAll(protocol_RequiredFeaturessMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'RequiredFeatures,Protocol' defined in xref_label
				db.update(protocol_RequiredFeaturesList,dbAction, "RequiredFeatures", "Protocol");
				
				//clear for next batch						
				protocol_RequiredFeaturesList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!protocol_RequiredFeaturesList.isEmpty())
		{
			total.set(total.get() + protocol_RequiredFeaturesList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			protocol_RequiredFeaturessMissingRefs.addAll(resolveForeignKeys(db, protocol_RequiredFeaturesList));
			protocol_RequiredFeaturesList.removeAll(protocol_RequiredFeaturessMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'RequiredFeatures,Protocol' defined in xref_label
			db.update(protocol_RequiredFeaturesList,dbAction, "RequiredFeatures", "Protocol");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Protocol_RequiredFeatures> protocol_RequiredFeaturess = new ArrayList<Protocol_RequiredFeatures>(protocol_RequiredFeaturessMissingRefs);

		int iterationCount = 0;

		do
		{
			protocol_RequiredFeaturessMissingRefs = resolveForeignKeys(db, protocol_RequiredFeaturessMissingRefs);
			
			LinkedHashSet<Protocol_RequiredFeatures> differenceSet = new LinkedHashSet<Protocol_RequiredFeatures>();
			Sets.symmetricDifference(new LinkedHashSet<Protocol_RequiredFeatures>(protocol_RequiredFeaturess), new LinkedHashSet<Protocol_RequiredFeatures>(protocol_RequiredFeaturessMissingRefs)).copyInto(differenceSet);
			List<Protocol_RequiredFeatures> resolvableprotocol_RequiredFeaturess = new ArrayList<Protocol_RequiredFeatures>(differenceSet);
			
			protocol_RequiredFeaturess.removeAll(resolvableprotocol_RequiredFeaturess);
			
			db.update(resolvableprotocol_RequiredFeaturess,dbAction, "RequiredFeatures", "Protocol");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Protocol_RequiredFeatures blaat : protocol_RequiredFeaturessMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'protocol_RequiredFeatures' entity failed:"
								+ "This is probably caused by a(n) 'protocol_RequiredFeatures' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (protocol_RequiredFeaturessMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " protocol_RequiredFeatures from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param protocol_RequiredFeaturesList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Protocol_RequiredFeatures> resolveForeignKeys(Database db, List<Protocol_RequiredFeatures> protocol_RequiredFeaturesList) throws Exception
	{
		//keep a list of Protocol_RequiredFeatures instances that miss a reference which might be resolvable later
		List<Protocol_RequiredFeatures> protocol_RequiredFeaturessMissingRefs = new ArrayList<Protocol_RequiredFeatures>();
	
		//resolve xref 'requiredFeatures' from observableFeature.Identifier -> observableFeature.id
		for(Protocol_RequiredFeatures o: protocol_RequiredFeaturesList) 
		{
			if(o.getRequiredFeatures_Identifier() != null) 
				requiredFeaturesKeymap.put(o.getRequiredFeatures_Identifier(), null);
		}
		
		if(requiredFeaturesKeymap.size() > 0) 
		{
			List<ObservableFeature> requiredFeaturesList = db.query(ObservableFeature.class).in("Identifier",new ArrayList<Object>(requiredFeaturesKeymap.keySet())).find();
			for(ObservableFeature xref :  requiredFeaturesList)
			{
				requiredFeaturesKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'protocol' from protocol.Identifier -> protocol.id
		for(Protocol_RequiredFeatures o: protocol_RequiredFeaturesList) 
		{
			if(o.getProtocol_Identifier() != null) 
				protocolKeymap.put(o.getProtocol_Identifier(), null);
		}
		
		if(protocolKeymap.size() > 0) 
		{
			List<Protocol> protocolList = db.query(Protocol.class).in("Identifier",new ArrayList<Object>(protocolKeymap.keySet())).find();
			for(Protocol xref :  protocolList)
			{
				protocolKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Protocol_RequiredFeatures o:  protocol_RequiredFeaturesList)
		{
			while(true){
				//update xref RequiredFeatures
				if(o.getRequiredFeatures_Identifier() != null) 
				{
					String key = o.getRequiredFeatures_Identifier();
					if(requiredFeaturesKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Protocol_RequiredFeatures' objects failed: cannot find ObservableFeature for requiredFeatures_Identifier='"+o.getRequiredFeatures_Identifier()+"'");
					}
					o.setRequiredFeatures_Id(requiredFeaturesKeymap.get(key));
				}
				//update xref Protocol
				if(o.getProtocol_Identifier() != null) 
				{
					String key = o.getProtocol_Identifier();
					if(protocolKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Protocol_RequiredFeatures' objects failed: cannot find Protocol for protocol_Identifier='"+o.getProtocol_Identifier()+"'");
					}
					o.setProtocol_Id(protocolKeymap.get(key));
				}
				break;
			}
		}
		
		requiredFeaturesKeymap.clear();
		protocolKeymap.clear();
		
		return protocol_RequiredFeaturessMissingRefs;
	}
}

