
/* File:        org.molgenis.omx/model/Panel.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ.target;

/**
 * Panel: The Panel class defines groups of individuals based on
				cohort design, case/controls, families, etc. For instance:
				'LifeLines
				cohort', 'middle aged man', 'recombinant mouse inbred Line
				dba x b6'
				or 'Smith family'. A Panel can act as a single
				ObservationTarget.
				For example: average height (Measurement) in the
				LifeLines cohort
				(Panel) is 174cm (ObservedValue). The Panel class
				maps to XGAP:Strain and PaGE:Panel
				classes. In METABASE this is
				assumed there is one panel per study.
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "Panel"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.observ.target.db.PanelEntityListener.class})
public class Panel extends org.molgenis.omx.observ.ObservationTarget 
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String PANELTYPE = "PanelType";
	public final static String PANELTYPE_IDENTIFIER = "PanelType_Identifier";
	public final static String NUMBEROFINDIVIDUALS = "NumberOfIndividuals";
	public final static String SPECIES = "Species";
	public final static String SPECIES_IDENTIFIER = "Species_Identifier";
	public final static String INDIVIDUALS = "Individuals";
	public final static String INDIVIDUALS_IDENTIFIER = "Individuals_Identifier";
	public final static String ID = "id";
	
	//static methods
	/**
	 * Shorthand for db.query(Panel.class).
	 */
	public static org.molgenis.framework.db.Query<? extends Panel> query(org.molgenis.framework.db.Database db)
	{
		return db.query(Panel.class);
	}
	
	/**
	 * Shorthand for db.find(Panel.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends Panel> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(Panel.class, rules);
	}	
	
	/**
	 * 
	 */
	public static Panel findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Panel> q = db.query(Panel.class);
		q = q.eq(Panel.ID, id);
		java.util.List<Panel> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static Panel findByIdentifier(org.molgenis.framework.db.Database db, String identifier) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Panel> q = db.query(Panel.class);
		q = q.eq(Panel.IDENTIFIER, identifier);
		java.util.List<Panel> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//Indicate the type of Panel (example: Sample panel, AssayedPanel, Natural=wild type, Parental=parents of a cross, F1=First generation of cross, RCC=Recombinant congenic, CSS=chromosome substitution)[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="PanelType")   	
	
				

	private org.molgenis.omx.observ.target.OntologyTerm panelType = null;
	@javax.persistence.Transient
	private Integer panelType_id = null;	
	@javax.persistence.Transient
	private String panelType_Identifier = null;						

	//NumberOfIndividuals[type=int]
	@javax.persistence.Column(name="NumberOfIndividuals", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="numberOfIndividuals")
	
				

	@javax.validation.constraints.NotNull
	private Integer numberOfIndividuals =  null;

	//The species this panel is an instance of/part of/extracted from.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Species")   	
	
				

	private org.molgenis.omx.observ.target.Species species = null;
	@javax.persistence.Transient
	private Integer species_id = null;	
	@javax.persistence.Transient
	private String species_Identifier = null;						

	//The list of individuals in this panel[type=mref]
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Individuals", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="Panel_Individuals", 
			joinColumns=@javax.persistence.JoinColumn(name="Panel"), inverseJoinColumns=@javax.persistence.JoinColumn(name="Individuals"))
	
				

	private java.util.List<org.molgenis.omx.observ.target.Individual> individuals = new java.util.ArrayList<org.molgenis.omx.observ.target.Individual>();
	@javax.persistence.Transient
	private java.util.List<Integer> individuals_id = new java.util.ArrayList<Integer>();		
	@javax.persistence.Transient
	private java.util.List<String> individuals_Identifier = new java.util.ArrayList<String>();

	//automatically generated internal id, only for internal use.[type=int]
	

	//constructors
	public Panel()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	/** copy constructor */
	public Panel(Panel copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the Indicate the type of Panel (example: Sample panel, AssayedPanel, Natural=wild type, Parental=parents of a cross, F1=First generation of cross, RCC=Recombinant congenic, CSS=chromosome substitution).
	 * @return panelType.
	 */
	public org.molgenis.omx.observ.target.OntologyTerm getPanelType()
	{
		return this.panelType;
	}
	
	@Deprecated
	public org.molgenis.omx.observ.target.OntologyTerm getPanelType(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Indicate the type of Panel (example: Sample panel, AssayedPanel, Natural=wild type, Parental=parents of a cross, F1=First generation of cross, RCC=Recombinant congenic, CSS=chromosome substitution).
	 * @param panelType
	 */
	public void setPanelType( org.molgenis.omx.observ.target.OntologyTerm panelType)
	{
		
		this.panelType = panelType;
	}

	
	
	/**
	 * Set foreign key for field panelType.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setPanelType_Id(Integer panelType_id)
	{
		this.panelType_id = panelType_id;
	}	

	public void setPanelType(Integer panelType_id)
	{
		this.panelType_id = panelType_id;
	}
	
	public Integer getPanelType_Id()
	{
		
		if(panelType != null) 
		{
			return panelType.getId();
		}
		else
		{
			return panelType_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference PanelType to OntologyTerm.Id.
	 */
	public String getPanelType_Identifier()
	{		
		//FIXME should we auto-load based on getPanelType()?	
		if(panelType != null) {
			return panelType.getIdentifier();
		} else {
			return panelType_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference PanelType to <a href="OntologyTerm.html#Id">OntologyTerm.Id</a>.
	 * Implies setPanelType(null) until save
	 */
	public void setPanelType_Identifier(String panelType_Identifier)
	{
		this.panelType_Identifier = panelType_Identifier;
	}		
	 
	

	/**
	 * Get the NumberOfIndividuals.
	 * @return numberOfIndividuals.
	 */
	public Integer getNumberOfIndividuals()
	{
		return this.numberOfIndividuals;
	}
	
	@Deprecated
	public Integer getNumberOfIndividuals(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the NumberOfIndividuals.
	 * @param numberOfIndividuals
	 */
	public void setNumberOfIndividuals( Integer numberOfIndividuals)
	{
		
		this.numberOfIndividuals = numberOfIndividuals;
	}

	

	/**
	 * Get the The species this panel is an instance of/part of/extracted from..
	 * @return species.
	 */
	public org.molgenis.omx.observ.target.Species getSpecies()
	{
		return this.species;
	}
	
	@Deprecated
	public org.molgenis.omx.observ.target.Species getSpecies(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The species this panel is an instance of/part of/extracted from..
	 * @param species
	 */
	public void setSpecies( org.molgenis.omx.observ.target.Species species)
	{
		
		this.species = species;
	}

	
	
	/**
	 * Set foreign key for field species.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setSpecies_Id(Integer species_id)
	{
		this.species_id = species_id;
	}	

	public void setSpecies(Integer species_id)
	{
		this.species_id = species_id;
	}
	
	public Integer getSpecies_Id()
	{
		
		if(species != null) 
		{
			return species.getId();
		}
		else
		{
			return species_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference Species to Species.Id.
	 */
	public String getSpecies_Identifier()
	{		
		//FIXME should we auto-load based on getSpecies()?	
		if(species != null) {
			return species.getIdentifier();
		} else {
			return species_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Species to <a href="Species.html#Id">Species.Id</a>.
	 * Implies setSpecies(null) until save
	 */
	public void setSpecies_Identifier(String species_Identifier)
	{
		this.species_Identifier = species_Identifier;
	}		
	 
	

	/**
	 * Get the The list of individuals in this panel.
	 * @return individuals.
	 */
	public java.util.List<org.molgenis.omx.observ.target.Individual> getIndividuals()
	{
		return this.individuals;
	}
	
	@Deprecated
	public java.util.List<org.molgenis.omx.observ.target.Individual> getIndividuals(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The list of individuals in this panel.
	 * @param individuals
	 */
	public void setIndividuals( java.util.List<org.molgenis.omx.observ.target.Individual> individuals)
	{
		
		this.individuals = individuals;
	}

	
	public void setIndividuals_Id(Integer ... individuals)
	{
		this.setIndividuals_Id(java.util.Arrays.asList(individuals));
	}	
	
	public void setIndividuals(org.molgenis.omx.observ.target.Individual ... individuals)
	{
		this.setIndividuals(java.util.Arrays.asList(individuals));
	}	
	
	/**
	 * Set foreign key for field individuals.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setIndividuals_Id(java.util.List<Integer> individuals_id)
	{
		this.individuals_id = individuals_id;
	}	
	
	public java.util.List<Integer> getIndividuals_Id()
	{
		if(individuals != null && !individuals.isEmpty()) {
			java.util.List<Integer> result = new java.util.ArrayList<Integer>();
			for (int i = 0; i < individuals.size(); i++)
				result.add(individuals.get(i).getId());
			return result;
		} else {
			if(individuals_id == null) {
				individuals_id = new java.util.ArrayList<Integer>();
			}		
			return individuals_id;
		}
	}	
	
	/**
	 * Get a pretty label for cross reference Individuals to <a href="Individual.html#Id">Individual.Id</a>.
	 */
	public java.util.List<String> getIndividuals_Identifier()
	{
		if(this.individuals != null && !this.individuals.isEmpty())
		{
			java.util.List<String> result = new java.util.ArrayList<String>(this.individuals.size());
			for(org.molgenis.omx.observ.target.Individual o: individuals) result.add(o.getIdentifier());
			return java.util.Collections.unmodifiableList(result);
		}	
		else
		{	
			return individuals_Identifier;
		}
	}
	
	/**
	 * Update the foreign key Individuals
	 * This sets individuals to null until next database transaction.
	 */
	public void setIndividuals_Identifier(java.util.List<String> individuals_Identifier)
	{
		this.individuals_Identifier = individuals_Identifier;
	}		
	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();
		if (name.equals("description"))
			return getDescription();
		if (name.equals("paneltype"))
			return getPanelType();
		if(name.equals("paneltype_id"))
			return getPanelType_Id();
		if(name.equals("paneltype_identifier"))
			return getPanelType_Identifier();
		if (name.equals("numberofindividuals"))
			return getNumberOfIndividuals();
		if (name.equals("species"))
			return getSpecies();
		if(name.equals("species_id"))
			return getSpecies_Id();
		if(name.equals("species_identifier"))
			return getSpecies_Identifier();
		if (name.equals("individuals"))
			return getIndividuals();
		if(name.equals("individuals_id"))
			return getIndividuals_Id();
		if(name.equals("individuals_identifier"))
			return getIndividuals_Identifier();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getIdentifier() == null) throw new org.molgenis.framework.db.DatabaseException("required field identifier is null");
		if(this.getName() == null) throw new org.molgenis.framework.db.DatabaseException("required field name is null");
		if(this.get__Type() == null) throw new org.molgenis.framework.db.DatabaseException("required field __Type is null");
		if(this.getNumberOfIndividuals() == null) throw new org.molgenis.framework.db.DatabaseException("required field numberOfIndividuals is null");
	}
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("panel_id") != null) this.setId(entity.getInt("panel_id"));
		else if( entity.getInt("Panel_id") != null) this.setId(entity.getInt("Panel_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("panel_identifier") != null) this.setIdentifier(entity.getString("panel_identifier"));
		else if( entity.getString("Panel_Identifier") != null) this.setIdentifier(entity.getString("Panel_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("panel_name") != null) this.setName(entity.getString("panel_name"));
		else if( entity.getString("Panel_Name") != null) this.setName(entity.getString("Panel_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("panel___type") != null) this.set__Type(entity.getString("panel___type"));
		else if( entity.getString("Panel___Type") != null) this.set__Type(entity.getString("Panel___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("panel_description") != null) this.setDescription(entity.getString("panel_description"));
		else if( entity.getString("Panel_description") != null) this.setDescription(entity.getString("Panel_description"));
		//set PanelType
		// query formal name, else lowercase name
		if(entity.getInt("PanelType_id") != null) this.setPanelType(entity.getInt("PanelType_id"));
		else if(entity.getInt("paneltype_id") != null) this.setPanelType(entity.getInt("paneltype_id"));
		else if(strict) this.setPanelType(entity.getInt("PanelType_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("Panel_PanelType_id") != null) this.setPanelType(entity.getInt("Panel_PanelType_id"));
		else if( entity.getInt("panel_paneltype_id") != null) this.setPanelType(entity.getInt("panel_paneltype_id"));
		//alias of xref
		if( entity.get("PanelType") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("PanelType").toString())) {
				org.molgenis.omx.observ.target.OntologyTerm instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("PanelType"), org.molgenis.omx.observ.target.OntologyTerm.class);
				this.setPanelType(instance);				
			} else {
				this.setPanelType_Id(entity.getInt("PanelType")); 
			}
		}
		else if( entity.get("paneltype") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("paneltype").toString())) {
				org.molgenis.omx.observ.target.OntologyTerm instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("paneltype"), org.molgenis.omx.observ.target.OntologyTerm.class);
				this.setPanelType(instance);				
			} else {
				this.setPanelType_Id(entity.getInt("PanelType"));
			}
		}
		if( entity.get("Panel_PanelType") != null)
			this.setPanelType_Id(entity.getInt("Panel_PanelType"));			
		else if( entity.get("panel_paneltype") != null)
			this.setPanelType_Id(entity.getInt("panel_paneltype"));
			
		if( entity.get("Panel.PanelType") != null) 
			this.setPanelType((org.molgenis.omx.observ.target.OntologyTerm)entity.get("Panel.PanelType_id"));
		else if( entity.get("panel.paneltype") != null) 
			this.setPanelType((org.molgenis.omx.observ.target.OntologyTerm)entity.get("panel.paneltype_id"));	
		//set label for field PanelType
		if(entity.get("PanelType_Identifier") != null) this.setPanelType_Identifier(entity.getString("PanelType_Identifier"));
		else if(entity.get("paneltype_identifier") != null) this.setPanelType_Identifier(entity.getString("paneltype_identifier"));
		else if(strict) this.setPanelType_Identifier(entity.getString("PanelType_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("Panel_PanelType_Identifier") != null ) this.setPanelType_Identifier(entity.getString("Panel_PanelType_Identifier"));		
		else if( entity.get("panel_paneltype_identifier") != null ) this.setPanelType_Identifier(entity.getString("panel_paneltype_identifier"));
		//set NumberOfIndividuals
		// query formal name, else lowercase name
		if(entity.getInt("numberofindividuals") != null) this.setNumberOfIndividuals(entity.getInt("numberofindividuals"));
		else if(entity.getInt("NumberOfIndividuals") != null) this.setNumberOfIndividuals(entity.getInt("NumberOfIndividuals"));
		else if(strict) this.setNumberOfIndividuals(entity.getInt("numberofindividuals")); // setting null is not an option due to function overloading
		if( entity.getInt("panel_numberofindividuals") != null) this.setNumberOfIndividuals(entity.getInt("panel_numberofindividuals"));
		else if( entity.getInt("Panel_NumberOfIndividuals") != null) this.setNumberOfIndividuals(entity.getInt("Panel_NumberOfIndividuals"));
		//set Species
		// query formal name, else lowercase name
		if(entity.getInt("Species_id") != null) this.setSpecies(entity.getInt("Species_id"));
		else if(entity.getInt("species_id") != null) this.setSpecies(entity.getInt("species_id"));
		else if(strict) this.setSpecies(entity.getInt("Species_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("Panel_Species_id") != null) this.setSpecies(entity.getInt("Panel_Species_id"));
		else if( entity.getInt("panel_species_id") != null) this.setSpecies(entity.getInt("panel_species_id"));
		//alias of xref
		if( entity.get("Species") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("Species").toString())) {
				org.molgenis.omx.observ.target.Species instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("Species"), org.molgenis.omx.observ.target.Species.class);
				this.setSpecies(instance);				
			} else {
				this.setSpecies_Id(entity.getInt("Species")); 
			}
		}
		else if( entity.get("species") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("species").toString())) {
				org.molgenis.omx.observ.target.Species instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("species"), org.molgenis.omx.observ.target.Species.class);
				this.setSpecies(instance);				
			} else {
				this.setSpecies_Id(entity.getInt("Species"));
			}
		}
		if( entity.get("Panel_Species") != null)
			this.setSpecies_Id(entity.getInt("Panel_Species"));			
		else if( entity.get("panel_species") != null)
			this.setSpecies_Id(entity.getInt("panel_species"));
			
		if( entity.get("Panel.Species") != null) 
			this.setSpecies((org.molgenis.omx.observ.target.Species)entity.get("Panel.Species_id"));
		else if( entity.get("panel.species") != null) 
			this.setSpecies((org.molgenis.omx.observ.target.Species)entity.get("panel.species_id"));	
		//set label for field Species
		if(entity.get("Species_Identifier") != null) this.setSpecies_Identifier(entity.getString("Species_Identifier"));
		else if(entity.get("species_identifier") != null) this.setSpecies_Identifier(entity.getString("species_identifier"));
		else if(strict) this.setSpecies_Identifier(entity.getString("Species_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("Panel_Species_Identifier") != null ) this.setSpecies_Identifier(entity.getString("Panel_Species_Identifier"));		
		else if( entity.get("panel_species_identifier") != null ) this.setSpecies_Identifier(entity.getString("panel_species_identifier"));
		//set Individuals
		if( entity.get("Individuals") != null || entity.get("Panel_Individuals") != null || entity.get("individuals") != null || entity.get("panel_individuals") != null) 
		{
			java.util.List<Integer> values = new java.util.ArrayList<Integer>();
			java.util.List<?> mrefs = entity.getList("Individuals");
			if(mrefs == null) mrefs = entity.getList("individuals");
			if(entity.get("panel_individuals")!= null) mrefs = entity.getList("panel_individuals");
			else if(entity.get("Panel_Individuals")!= null) mrefs = entity.getList("Panel_Individuals");
			if(mrefs != null) for(Object ref: mrefs)
			{
				if(ref instanceof String)
					values.add(Integer.parseInt((String)ref));
				else if(ref instanceof org.molgenis.util.AbstractEntity) 	
					values.add((Integer)((org.molgenis.util.AbstractEntity)ref).getIdValue() );
				else
					values.add((Integer)ref);		
			}											
			this.setIndividuals_Id( values );
		}
		//set labels Identifier for mref field Individuals	
		if( entity.get("Individuals_Identifier") != null || entity.get("Panel_Individuals_Identifier")!= null || entity.get("individuals_identifier") != null || entity.get("panel_individuals_identifier") != null) 
		{
			java.util.List<String> values = new java.util.ArrayList<String>();
			java.util.List<?> mrefs = entity.getList("Individuals_Identifier");
			if(mrefs == null) mrefs = entity.getList("individuals_identifier");
			if(entity.get("Panel_Individuals_Identifier")!= null) mrefs = entity.getList("Panel_Individuals_Identifier");
			else if(entity.get("panel_individuals_identifier")!= null) mrefs = entity.getList("panel_individuals_identifier");
			if(mrefs != null) 
				for(Object ref: mrefs)
				{
					String[] refs = ref.toString().split("\\|");
					for(String r : refs) {
						values.add(r);	
					}						
				}							
			this.setIndividuals_Identifier( values );			
		}	
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "Panel(";
		result+= "id='" + getId()+"' ";	
		result+= "identifier='" + getIdentifier()+"' ";	
		result+= "name='" + getName()+"' ";	
		result+= "__Type='" + get__Type()+"' ";	
		result+= "description='" + getDescription()+"' ";	
		result+= " panelType_id='" + getPanelType_Id()+"' ";	
		result+= " panelType_identifier='" + getPanelType_Identifier()+"' ";
		result+= "numberOfIndividuals='" + getNumberOfIndividuals()+"' ";	
		result+= " species_id='" + getSpecies_Id()+"' ";	
		result+= " species_identifier='" + getSpecies_Identifier()+"' ";
		result+= " individuals_id='" + getIndividuals_Id()+"' ";	
		result+= " individuals_identifier='" + getIndividuals_Identifier()+"' ";
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of Panel.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Identifier");
		}
		{
			fields.add("Name");
		}
		{
			fields.add("__Type");
		}
		{
			fields.add("description");
		}
		{
			fields.add("PanelType_id");
		}
		fields.add("PanelType_Identifier");
		{
			fields.add("NumberOfIndividuals");
		}
		{
			fields.add("Species_id");
		}
		fields.add("Species_Identifier");
		{
			fields.add("Individuals_id");
		}
		fields.add("Individuals_Identifier");
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "identifier" +sep
		+ "name" +sep
		+ "__Type" +sep
		+ "description" +sep
		+ "panelType" +sep
		+ "numberOfIndividuals" +sep
		+ "species" +sep
		+ "individuals" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("panelType")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("species")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("individuals")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdentifier();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = get__Type();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDescription();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getPanelType();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getNumberOfIndividuals();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSpecies();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIndividuals();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public Panel create(org.molgenis.data.Entity entity) throws Exception
	{
		Panel e = new Panel();
		e.set(entity);
		return e;
	}
	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
}
