/* File:        org.molgenis.omx/model/Individual.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 22, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.target.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class IndividualJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.observ.target.Individual>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(IndividualJpaMapper.class);

	public IndividualJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Individual.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", Individual.Mother"
			+", Individual.Father"
			//parent is SimpleTree(name='Mother')
			+", xref_Mother.Identifier AS Mother_Identifier"
			//parent is SimpleTree(name='Father')
			+", xref_Father.Identifier AS Father_Identifier"
			+" FROM Individual "
			+" INNER JOIN ObservationTarget ON (Individual.id = ObservationTarget.id)"
			+" INNER JOIN Characteristic ON (Individual.id = Characteristic.id)"

			
			//label for Mother=Identifier
//path==Mother. type==xref.
//path==Mother_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Mother " 
			+" ON xref_Mother.id = Individual.Mother"
			
			//label for Father=Identifier
//path==Father. type==xref.
//path==Father_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Father " 
			+" ON xref_Father.id = Individual.Father"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.observ.target.Individual entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'Mother' is known in the databse
			if(entity.getMother() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getMother().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.IndividualJpaMapper(getDatabase()).create(entity.getMother());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getMother()) && entity.getMother().getIdValue() != null)
					entity.setMother(getEntityManager().getReference(org.molgenis.omx.observ.target.Individual.class, entity.getMother().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getMother_Id() != null) {
					entity.setMother((org.molgenis.omx.observ.target.Individual)getEntityManager().find(org.molgenis.omx.observ.target.Individual.class, entity.getMother_Id()));
				}
			}
			//check if the object refered by 'Father' is known in the databse
			if(entity.getFather() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getFather().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.IndividualJpaMapper(getDatabase()).create(entity.getFather());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getFather()) && entity.getFather().getIdValue() != null)
					entity.setFather(getEntityManager().getReference(org.molgenis.omx.observ.target.Individual.class, entity.getFather().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getFather_Id() != null) {
					entity.setFather((org.molgenis.omx.observ.target.Individual)getEntityManager().find(org.molgenis.omx.observ.target.Individual.class, entity.getFather_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.observ.target.Individual individual) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				individual = getEntityManager().getReference(org.molgenis.omx.observ.target.Individual.class, individual.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The individual with id " + individual.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(individual);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.observ.target.Individual individual) throws org.molgenis.framework.db.DatabaseException {
		try {







			//4
			org.molgenis.omx.observ.target.Individual motherNew = individual.getMother();

			if (motherNew == null) { //object is reference by xref		
                            if(individual.getMother_Id() != null) {
                                individual.setMother((org.molgenis.omx.observ.target.Individual)getEntityManager().find(org.molgenis.omx.observ.target.Individual.class, individual.getMother_Id()));
                            }
			}


			//4
			org.molgenis.omx.observ.target.Individual fatherNew = individual.getFather();

			if (fatherNew == null) { //object is reference by xref		
                            if(individual.getFather_Id() != null) {
                                individual.setFather((org.molgenis.omx.observ.target.Individual)getEntityManager().find(org.molgenis.omx.observ.target.Individual.class, individual.getFather_Id()));
                            }
			}
			if(!getEntityManager().contains(individual)) {
				individual = getEntityManager().merge(individual);
			}
			


		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.observ.target.Individual> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.observ.target.Individual individual : entities) 
			{
				create(individual);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.observ.target.Individual> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.observ.target.Individual individual : entities) 
			{
				edit(individual);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.observ.target.Individual> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.observ.target.Individual individual : entities) 
			{
				destroy(individual);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Individual_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Individual_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("Individual_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Individual___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("Individual_description".equalsIgnoreCase(fieldName)) return "description";
		if("Mother".equalsIgnoreCase(fieldName)) return "Mother";
		if("Individual_Mother".equalsIgnoreCase(fieldName)) return "Mother";
		if("Father".equalsIgnoreCase(fieldName)) return "Father";
		if("Individual_Father".equalsIgnoreCase(fieldName)) return "Father";
		if("Mother_id".equalsIgnoreCase(fieldName)) return "Mother";
		if("Individual_Mother_id".equalsIgnoreCase(fieldName)) return "Mother";
		if("Mother_Identifier".equalsIgnoreCase(fieldName)) return "Mother.Identifier";	
		if("Individual_Mother_Identifier".equalsIgnoreCase(fieldName)) return "Mother.Identifier";
		if("Father_id".equalsIgnoreCase(fieldName)) return "Father";
		if("Individual_Father_id".equalsIgnoreCase(fieldName)) return "Father";
		if("Father_Identifier".equalsIgnoreCase(fieldName)) return "Father.Identifier";	
		if("Individual_Father_Identifier".equalsIgnoreCase(fieldName)) return "Father.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.observ.target.Individual> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.observ.target.Individual>(size);
	}			

	@Override
	public org.molgenis.omx.observ.target.Individual create()
	{
		return new org.molgenis.omx.observ.target.Individual();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.observ.target.Individual> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'mother' to individual.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> motherRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'father' to individual.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> fatherRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.observ.target.Individual object: entities)
		{
			//create xref/mref rule filtering Individual on the label Identifier
			if(object.getMother_Id() == null && object.getMother_Identifier() != null)
			{
				Object label = object.getMother_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!motherRules.containsKey(label))
					{
						motherRules.put(""+label, xrefFilter);
						motherRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering Individual on the label Identifier
			if(object.getFather_Id() == null && object.getFather_Identifier() != null)
			{
				Object label = object.getFather_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!fatherRules.containsKey(label))
					{
						fatherRules.put(""+label, xrefFilter);
						fatherRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'mother' to individual.id using Identifier)
		final java.util.Map<String,Integer> mother_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(motherRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.Individual> motherList = null;
			try
			{
				motherList = getDatabase().find(org.molgenis.omx.observ.target.Individual.class, motherRules.values().toArray(new org.molgenis.framework.db.QueryRule[motherRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.Individual xref :  motherList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				mother_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'father' to individual.id using Identifier)
		final java.util.Map<String,Integer> father_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(fatherRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.Individual> fatherList = null;
			try
			{
				fatherList = getDatabase().find(org.molgenis.omx.observ.target.Individual.class, fatherRules.values().toArray(new org.molgenis.framework.db.QueryRule[fatherRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.Individual xref :  fatherList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				father_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.observ.target.Individual object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getMother_Id() == null )
			{
					String key = "";
					if(object.getMother_Identifier() != null)
						key += 	object.getMother_Identifier();
					
					if(!"".equals(key) && mother_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Mother_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setMother_Id(mother_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getFather_Id() == null )
			{
					String key = "";
					if(object.getFather_Identifier() != null)
						key += 	object.getFather_Identifier();
					
					if(!"".equals(key) && father_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Father_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setFather_Id(father_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "individual.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("mother".equalsIgnoreCase(fieldName) || "individual.mother".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("father".equalsIgnoreCase(fieldName) || "individual.father".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.observ.target.Individual> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.observ.target.Individual> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
