/* File:        org.molgenis.omx/model/Panel.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 22, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.target.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class PanelJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.observ.target.Panel>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(PanelJpaMapper.class);

	public PanelJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Panel.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", Panel.PanelType"
			+", Panel.NumberOfIndividuals"
			+", Panel.Species"
			//parent is SimpleTree(name='PanelType')
			+", xref_PanelType.Identifier AS PanelType_Identifier"
			//parent is SimpleTree(name='Species')
			+", xref_Species.Identifier AS Species_Identifier"
			+" FROM Panel "
			+" INNER JOIN ObservationTarget ON (Panel.id = ObservationTarget.id)"
			+" INNER JOIN Characteristic ON (Panel.id = Characteristic.id)"

			
			//label for PanelType=Identifier
//path==PanelType. type==xref.
//path==PanelType_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_PanelType " 
			+" ON xref_PanelType.id = Panel.PanelType"
			
			//label for Species=Identifier
//path==Species. type==xref.
//path==Species_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Species " 
			+" ON xref_Species.id = Panel.Species"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.observ.target.Panel entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'PanelType' is known in the databse
			if(entity.getPanelType() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getPanelType().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.OntologyTermJpaMapper(getDatabase()).create(entity.getPanelType());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getPanelType()) && entity.getPanelType().getIdValue() != null)
					entity.setPanelType(getEntityManager().getReference(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getPanelType().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getPanelType_Id() != null) {
					entity.setPanelType((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getPanelType_Id()));
				}
			}
			//check if the object refered by 'Species' is known in the databse
			if(entity.getSpecies() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getSpecies().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.SpeciesJpaMapper(getDatabase()).create(entity.getSpecies());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getSpecies()) && entity.getSpecies().getIdValue() != null)
					entity.setSpecies(getEntityManager().getReference(org.molgenis.omx.observ.target.Species.class, entity.getSpecies().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getSpecies_Id() != null) {
					entity.setSpecies((org.molgenis.omx.observ.target.Species)getEntityManager().find(org.molgenis.omx.observ.target.Species.class, entity.getSpecies_Id()));
				}
			}
	    java.util.List<org.molgenis.omx.observ.target.Individual> individualsList = entity.getIndividuals();
	    java.util.List<Integer> individualsIds = entity.getIndividuals_Id();
	    for(Integer individualsId : individualsIds) {
		org.molgenis.omx.observ.target.Individual individual = getEntityManager().getReference(org.molgenis.omx.observ.target.Individual.class, individualsId);
		if(!individualsList.contains(individual))
		    individualsList.add(individual);
	    }
	    entity.setIndividuals(individualsList);

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.observ.target.Panel panel) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				panel = getEntityManager().getReference(org.molgenis.omx.observ.target.Panel.class, panel.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The panel with id " + panel.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(panel);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.observ.target.Panel panel) throws org.molgenis.framework.db.DatabaseException {
		try {







			//6
			org.molgenis.omx.observ.target.OntologyTerm panelTypeNew = panel.getPanelType();

			if (panelTypeNew == null) { //object is reference by xref		
                            if(panel.getPanelType_Id() != null) {
                                panel.setPanelType((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, panel.getPanelType_Id()));
                            }
			}



			//1
			org.molgenis.omx.observ.target.Species speciesNew = panel.getSpecies();

			if (speciesNew == null) { //object is reference by xref		
                            if(panel.getSpecies_Id() != null) {
                                panel.setSpecies((org.molgenis.omx.observ.target.Species)getEntityManager().find(org.molgenis.omx.observ.target.Species.class, panel.getSpecies_Id()));
                            }
			}


			//4
			for(org.molgenis.omx.observ.target.Individual m : panel.getIndividuals()) {
				if(m.getId() == null) {
					getEntityManager().persist(m);
				}
			}
			
			for(Integer id : panel.getIndividuals_Id()) {
				org.molgenis.omx.observ.target.Individual mref = getEntityManager().find(org.molgenis.omx.observ.target.Individual.class, id);
				if(!panel.getIndividuals().contains(mref)) {
					panel.getIndividuals().add(mref);
				}
			}    
			if(!getEntityManager().contains(panel)) {
				panel = getEntityManager().merge(panel);
			}
			


		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.observ.target.Panel> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.observ.target.Panel panel : entities) 
			{
				create(panel);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.observ.target.Panel> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.observ.target.Panel panel : entities) 
			{
				edit(panel);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.observ.target.Panel> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.observ.target.Panel panel : entities) 
			{
				destroy(panel);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Panel_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Panel_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("Panel_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Panel___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("Panel_description".equalsIgnoreCase(fieldName)) return "description";
		if("PanelType".equalsIgnoreCase(fieldName)) return "PanelType";
		if("Panel_PanelType".equalsIgnoreCase(fieldName)) return "PanelType";
		if("NumberOfIndividuals".equalsIgnoreCase(fieldName)) return "NumberOfIndividuals";
		if("Panel_NumberOfIndividuals".equalsIgnoreCase(fieldName)) return "NumberOfIndividuals";
		if("Species".equalsIgnoreCase(fieldName)) return "Species";
		if("Panel_Species".equalsIgnoreCase(fieldName)) return "Species";
		if("PanelType_id".equalsIgnoreCase(fieldName)) return "PanelType";
		if("Panel_PanelType_id".equalsIgnoreCase(fieldName)) return "PanelType";
		if("PanelType_Identifier".equalsIgnoreCase(fieldName)) return "PanelType.Identifier";	
		if("Panel_PanelType_Identifier".equalsIgnoreCase(fieldName)) return "PanelType.Identifier";
		if("Species_id".equalsIgnoreCase(fieldName)) return "Species";
		if("Panel_Species_id".equalsIgnoreCase(fieldName)) return "Species";
		if("Species_Identifier".equalsIgnoreCase(fieldName)) return "Species.Identifier";	
		if("Panel_Species_Identifier".equalsIgnoreCase(fieldName)) return "Species.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.observ.target.Panel> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.observ.target.Panel>(size);
	}			

	@Override
	public org.molgenis.omx.observ.target.Panel create()
	{
		return new org.molgenis.omx.observ.target.Panel();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.observ.target.Panel> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'panelType' to ontologyTerm.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> panelTypeRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'species' to species.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> speciesRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'individuals' to individual.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> individualsRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.observ.target.Panel object: entities)
		{
			//create xref/mref rule filtering OntologyTerm on the label Identifier
			if(object.getPanelType_Id() == null && object.getPanelType_Identifier() != null)
			{
				Object label = object.getPanelType_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!panelTypeRules.containsKey(label))
					{
						panelTypeRules.put(""+label, xrefFilter);
						panelTypeRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering Species on the label Identifier
			if(object.getSpecies_Id() == null && object.getSpecies_Identifier() != null)
			{
				Object label = object.getSpecies_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!speciesRules.containsKey(label))
					{
						speciesRules.put(""+label, xrefFilter);
						speciesRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering Individual on the label Identifier
			if(object.getIndividuals_Id().size() == 0 && object.getIndividuals_Identifier().size() > 0)
			{
				for(Object label: object.getIndividuals_Identifier())
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!individualsRules.containsKey(label))
					{
						individualsRules.put(""+label, xrefFilter);
						individualsRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'panelType' to ontologyTerm.id using Identifier)
		final java.util.Map<String,Integer> panelType_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(panelTypeRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.OntologyTerm> panelTypeList = null;
			try
			{
				panelTypeList = getDatabase().find(org.molgenis.omx.observ.target.OntologyTerm.class, panelTypeRules.values().toArray(new org.molgenis.framework.db.QueryRule[panelTypeRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.OntologyTerm xref :  panelTypeList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				panelType_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'species' to species.id using Identifier)
		final java.util.Map<String,Integer> species_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(speciesRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.Species> speciesList = null;
			try
			{
				speciesList = getDatabase().find(org.molgenis.omx.observ.target.Species.class, speciesRules.values().toArray(new org.molgenis.framework.db.QueryRule[speciesRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.Species xref :  speciesList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				species_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'individuals' to individual.id using Identifier)
		final java.util.Map<String,Integer> individuals_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(individualsRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.Individual> individualsList = null;
			try
			{
				individualsList = getDatabase().find(org.molgenis.omx.observ.target.Individual.class, individualsRules.values().toArray(new org.molgenis.framework.db.QueryRule[individualsRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.Individual xref :  individualsList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				individuals_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.observ.target.Panel object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getPanelType_Id() == null )
			{
					String key = "";
					if(object.getPanelType_Identifier() != null)
						key += 	object.getPanelType_Identifier();
					
					if(!"".equals(key) && panelType_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("PanelType_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setPanelType_Id(panelType_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getSpecies_Id() == null )
			{
					String key = "";
					if(object.getSpecies_Identifier() != null)
						key += 	object.getSpecies_Identifier();
					
					if(!"".equals(key) && species_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Species_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setSpecies_Id(species_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getIndividuals_Id() == null || object.getIndividuals_Id().size() == 0)
			{
				java.util.List<Integer> idList = new java.util.ArrayList<Integer>();
				for(int j = 0; j < object.getIndividuals_Identifier().size(); j++)
				{
					String key = "";
					if(object.getIndividuals_Identifier().get(j) != null)
						key += 	object.getIndividuals_Identifier().get(j);
					
					if(!"".equals(key) && individuals_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Individuals_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						idList.add(individuals_Labels_to_IdMap.get(key));
					}
				}
				object.setIndividuals_Id(idList);
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "panel.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("panelType".equalsIgnoreCase(fieldName) || "panel.panelType".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("numberOfIndividuals".equalsIgnoreCase(fieldName) || "panel.numberOfIndividuals".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("species".equalsIgnoreCase(fieldName) || "panel.species".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.observ.target.Panel> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.observ.target.Panel> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
