
/* File:        org.molgenis.omx/model/DecimalValue.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.value.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.value.DecimalValue;


/**
 * Reads DecimalValue from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class DecimalValueEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(DecimalValueEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports DecimalValue from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<DecimalValue> decimalValuesMissingRefs = new ArrayList<DecimalValue>();
	
		//cache for objects to be imported from file (in batch)
		final List<DecimalValue> decimalValueList = new ArrayList<DecimalValue>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			DecimalValue object = new DecimalValue();
			object.set(entity, false);				
			decimalValueList.add(object);		
			
			//add to db when batch size is reached
			if(decimalValueList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				decimalValuesMissingRefs.addAll(resolveForeignKeys(db, decimalValueList));
				decimalValueList.removeAll(decimalValuesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
				db.update(decimalValueList,dbAction, "id");
				
				//clear for next batch						
				decimalValueList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!decimalValueList.isEmpty())
		{
			total.set(total.get() + decimalValueList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			decimalValuesMissingRefs.addAll(resolveForeignKeys(db, decimalValueList));
			decimalValueList.removeAll(decimalValuesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
			db.update(decimalValueList,dbAction, "id");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<DecimalValue> decimalValues = new ArrayList<DecimalValue>(decimalValuesMissingRefs);

		int iterationCount = 0;

		do
		{
			decimalValuesMissingRefs = resolveForeignKeys(db, decimalValuesMissingRefs);
			
			LinkedHashSet<DecimalValue> differenceSet = new LinkedHashSet<DecimalValue>();
			Sets.symmetricDifference(new LinkedHashSet<DecimalValue>(decimalValues), new LinkedHashSet<DecimalValue>(decimalValuesMissingRefs)).copyInto(differenceSet);
			List<DecimalValue> resolvabledecimalValues = new ArrayList<DecimalValue>(differenceSet);
			
			decimalValues.removeAll(resolvabledecimalValues);
			
			db.update(resolvabledecimalValues,dbAction, "id");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(DecimalValue blaat : decimalValuesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'decimalValue' entity failed:"
								+ "This is probably caused by a(n) 'decimalValue' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (decimalValuesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " decimalValue from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param decimalValueList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<DecimalValue> resolveForeignKeys(Database db, List<DecimalValue> decimalValueList) throws Exception
	{
		//keep a list of DecimalValue instances that miss a reference which might be resolvable later
		List<DecimalValue> decimalValuesMissingRefs = new ArrayList<DecimalValue>();
	
		//update objects with foreign key values
		for(DecimalValue o:  decimalValueList)
		{
			while(true){
				break;
			}
		}
		
		
		return decimalValuesMissingRefs;
	}
}

