
/* File:        org.molgenis.omx/model/EmailValue.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.value.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.value.EmailValue;


/**
 * Reads EmailValue from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class EmailValueEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(EmailValueEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports EmailValue from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<EmailValue> emailValuesMissingRefs = new ArrayList<EmailValue>();
	
		//cache for objects to be imported from file (in batch)
		final List<EmailValue> emailValueList = new ArrayList<EmailValue>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			EmailValue object = new EmailValue();
			object.set(entity, false);				
			emailValueList.add(object);		
			
			//add to db when batch size is reached
			if(emailValueList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				emailValuesMissingRefs.addAll(resolveForeignKeys(db, emailValueList));
				emailValueList.removeAll(emailValuesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
				db.update(emailValueList,dbAction, "id");
				
				//clear for next batch						
				emailValueList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!emailValueList.isEmpty())
		{
			total.set(total.get() + emailValueList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			emailValuesMissingRefs.addAll(resolveForeignKeys(db, emailValueList));
			emailValueList.removeAll(emailValuesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
			db.update(emailValueList,dbAction, "id");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<EmailValue> emailValues = new ArrayList<EmailValue>(emailValuesMissingRefs);

		int iterationCount = 0;

		do
		{
			emailValuesMissingRefs = resolveForeignKeys(db, emailValuesMissingRefs);
			
			LinkedHashSet<EmailValue> differenceSet = new LinkedHashSet<EmailValue>();
			Sets.symmetricDifference(new LinkedHashSet<EmailValue>(emailValues), new LinkedHashSet<EmailValue>(emailValuesMissingRefs)).copyInto(differenceSet);
			List<EmailValue> resolvableemailValues = new ArrayList<EmailValue>(differenceSet);
			
			emailValues.removeAll(resolvableemailValues);
			
			db.update(resolvableemailValues,dbAction, "id");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(EmailValue blaat : emailValuesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'emailValue' entity failed:"
								+ "This is probably caused by a(n) 'emailValue' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (emailValuesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " emailValue from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param emailValueList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<EmailValue> resolveForeignKeys(Database db, List<EmailValue> emailValueList) throws Exception
	{
		//keep a list of EmailValue instances that miss a reference which might be resolvable later
		List<EmailValue> emailValuesMissingRefs = new ArrayList<EmailValue>();
	
		//update objects with foreign key values
		for(EmailValue o:  emailValueList)
		{
			while(true){
				break;
			}
		}
		
		
		return emailValuesMissingRefs;
	}
}

