
/* File:        org.molgenis.omx/model/MrefValue_Value.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.value.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.Characteristic;
import org.molgenis.omx.observ.value.MrefValue;
import org.molgenis.omx.observ.value.MrefValue_Value;


/**
 * Reads MrefValue_Value from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class MrefValue_ValueEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(MrefValue_ValueEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'value' (maps characteristic.Identifier -> characteristic.id)			
	final Map<String,Integer> valueKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports MrefValue_Value from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<MrefValue_Value> mrefValue_ValuesMissingRefs = new ArrayList<MrefValue_Value>();
	
		//cache for objects to be imported from file (in batch)
		final List<MrefValue_Value> mrefValue_ValueList = new ArrayList<MrefValue_Value>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			MrefValue_Value object = new MrefValue_Value();
			object.set(entity, false);				
			mrefValue_ValueList.add(object);		
			
			//add to db when batch size is reached
			if(mrefValue_ValueList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				mrefValue_ValuesMissingRefs.addAll(resolveForeignKeys(db, mrefValue_ValueList));
				mrefValue_ValueList.removeAll(mrefValue_ValuesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Value,MrefValue' defined in xref_label
				db.update(mrefValue_ValueList,dbAction, "Value", "MrefValue");
				
				//clear for next batch						
				mrefValue_ValueList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!mrefValue_ValueList.isEmpty())
		{
			total.set(total.get() + mrefValue_ValueList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			mrefValue_ValuesMissingRefs.addAll(resolveForeignKeys(db, mrefValue_ValueList));
			mrefValue_ValueList.removeAll(mrefValue_ValuesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Value,MrefValue' defined in xref_label
			db.update(mrefValue_ValueList,dbAction, "Value", "MrefValue");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<MrefValue_Value> mrefValue_Values = new ArrayList<MrefValue_Value>(mrefValue_ValuesMissingRefs);

		int iterationCount = 0;

		do
		{
			mrefValue_ValuesMissingRefs = resolveForeignKeys(db, mrefValue_ValuesMissingRefs);
			
			LinkedHashSet<MrefValue_Value> differenceSet = new LinkedHashSet<MrefValue_Value>();
			Sets.symmetricDifference(new LinkedHashSet<MrefValue_Value>(mrefValue_Values), new LinkedHashSet<MrefValue_Value>(mrefValue_ValuesMissingRefs)).copyInto(differenceSet);
			List<MrefValue_Value> resolvablemrefValue_Values = new ArrayList<MrefValue_Value>(differenceSet);
			
			mrefValue_Values.removeAll(resolvablemrefValue_Values);
			
			db.update(resolvablemrefValue_Values,dbAction, "Value", "MrefValue");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(MrefValue_Value blaat : mrefValue_ValuesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'mrefValue_Value' entity failed:"
								+ "This is probably caused by a(n) 'mrefValue_Value' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (mrefValue_ValuesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " mrefValue_Value from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param mrefValue_ValueList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<MrefValue_Value> resolveForeignKeys(Database db, List<MrefValue_Value> mrefValue_ValueList) throws Exception
	{
		//keep a list of MrefValue_Value instances that miss a reference which might be resolvable later
		List<MrefValue_Value> mrefValue_ValuesMissingRefs = new ArrayList<MrefValue_Value>();
	
		//resolve xref 'value' from characteristic.Identifier -> characteristic.id
		for(MrefValue_Value o: mrefValue_ValueList) 
		{
			if(o.getValue_Identifier() != null) 
				valueKeymap.put(o.getValue_Identifier(), null);
		}
		
		if(valueKeymap.size() > 0) 
		{
			List<Characteristic> valueList = db.query(Characteristic.class).in("Identifier",new ArrayList<Object>(valueKeymap.keySet())).find();
			for(Characteristic xref :  valueList)
			{
				valueKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(MrefValue_Value o:  mrefValue_ValueList)
		{
			while(true){
				//update xref Value
				if(o.getValue_Identifier() != null) 
				{
					String key = o.getValue_Identifier();
					if(valueKeymap.get(key) == null)
					{
						throw new Exception("Import of 'MrefValue_Value' objects failed: cannot find Characteristic for value_Identifier='"+o.getValue_Identifier()+"'");
					}
					o.setValue_Id(valueKeymap.get(key));
				}
				break;
			}
		}
		
		valueKeymap.clear();
		
		return mrefValue_ValuesMissingRefs;
	}
}

