package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.Category;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class CategoryService
{
	private static final Logger logger = Logger.getLogger(CategoryService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_CATEGORY')")
	public Category create(Category category) throws DatabaseException
	{
		logger.debug("creating Category");
		db.add(category);
		return category;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_CATEGORY')")
	public Category read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Category");
		return db.findById(Category.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_CATEGORY')")
	public void update(Category category) throws DatabaseException
	{
		logger.debug("updating Category");
		db.update(category);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_CATEGORY')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Category");
		Category category = db.findById(Category.class, id);
		return db.remove(category) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_CATEGORY')")
	public Iterable<Category> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Category instances");
		return db.find(Category.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_CATEGORY')")
	public EntityPager<Category> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Category instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Category.class, queryRules.toArray(new QueryRule[0]));
		List<Category> categoryCollection = db.find(Category.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Category>(start, num, count, categoryCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_CATEGORY')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Category");
	}
}