package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class DataSetService
{
	private static final Logger logger = Logger.getLogger(DataSetService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_DATASET')")
	public DataSet create(DataSet dataSet) throws DatabaseException
	{
		logger.debug("creating DataSet");
		db.add(dataSet);
		return dataSet;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DATASET')")
	public DataSet read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving DataSet");
		return db.findById(DataSet.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_DATASET')")
	public void update(DataSet dataSet) throws DatabaseException
	{
		logger.debug("updating DataSet");
		db.update(dataSet);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_DATASET')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting DataSet");
		DataSet dataSet = db.findById(DataSet.class, id);
		return db.remove(dataSet) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DATASET')")
	public Iterable<DataSet> readAll() throws DatabaseException
	{
		logger.debug("retrieving all DataSet instances");
		return db.find(DataSet.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DATASET')")
	public EntityPager<DataSet> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all DataSet instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(DataSet.class, queryRules.toArray(new QueryRule[0]));
		List<DataSet> dataSetCollection = db.find(DataSet.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<DataSet>(start, num, count, dataSetCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DATASET')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("DataSet");
	}
}