package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.DateTimeValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class DateTimeValueService
{
	private static final Logger logger = Logger.getLogger(DateTimeValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_DATETIMEVALUE')")
	public DateTimeValue create(DateTimeValue dateTimeValue) throws DatabaseException
	{
		logger.debug("creating DateTimeValue");
		db.add(dateTimeValue);
		return dateTimeValue;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DATETIMEVALUE')")
	public DateTimeValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving DateTimeValue");
		return db.findById(DateTimeValue.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_DATETIMEVALUE')")
	public void update(DateTimeValue dateTimeValue) throws DatabaseException
	{
		logger.debug("updating DateTimeValue");
		db.update(dateTimeValue);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_DATETIMEVALUE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting DateTimeValue");
		DateTimeValue dateTimeValue = db.findById(DateTimeValue.class, id);
		return db.remove(dateTimeValue) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DATETIMEVALUE')")
	public Iterable<DateTimeValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all DateTimeValue instances");
		return db.find(DateTimeValue.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DATETIMEVALUE')")
	public EntityPager<DateTimeValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all DateTimeValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(DateTimeValue.class, queryRules.toArray(new QueryRule[0]));
		List<DateTimeValue> dateTimeValueCollection = db.find(DateTimeValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<DateTimeValue>(start, num, count, dateTimeValueCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DATETIMEVALUE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("DateTimeValue");
	}
}