package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.DecimalValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class DecimalValueService
{
	private static final Logger logger = Logger.getLogger(DecimalValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_DECIMALVALUE')")
	public DecimalValue create(DecimalValue decimalValue) throws DatabaseException
	{
		logger.debug("creating DecimalValue");
		db.add(decimalValue);
		return decimalValue;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DECIMALVALUE')")
	public DecimalValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving DecimalValue");
		return db.findById(DecimalValue.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_DECIMALVALUE')")
	public void update(DecimalValue decimalValue) throws DatabaseException
	{
		logger.debug("updating DecimalValue");
		db.update(decimalValue);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_DECIMALVALUE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting DecimalValue");
		DecimalValue decimalValue = db.findById(DecimalValue.class, id);
		return db.remove(decimalValue) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DECIMALVALUE')")
	public Iterable<DecimalValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all DecimalValue instances");
		return db.find(DecimalValue.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DECIMALVALUE')")
	public EntityPager<DecimalValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all DecimalValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(DecimalValue.class, queryRules.toArray(new QueryRule[0]));
		List<DecimalValue> decimalValueCollection = db.find(DecimalValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<DecimalValue>(start, num, count, decimalValueCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DECIMALVALUE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("DecimalValue");
	}
}