package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.EmailValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class EmailValueService
{
	private static final Logger logger = Logger.getLogger(EmailValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_EMAILVALUE')")
	public EmailValue create(EmailValue emailValue) throws DatabaseException
	{
		logger.debug("creating EmailValue");
		db.add(emailValue);
		return emailValue;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_EMAILVALUE')")
	public EmailValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving EmailValue");
		return db.findById(EmailValue.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_EMAILVALUE')")
	public void update(EmailValue emailValue) throws DatabaseException
	{
		logger.debug("updating EmailValue");
		db.update(emailValue);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_EMAILVALUE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting EmailValue");
		EmailValue emailValue = db.findById(EmailValue.class, id);
		return db.remove(emailValue) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_EMAILVALUE')")
	public Iterable<EmailValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all EmailValue instances");
		return db.find(EmailValue.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_EMAILVALUE')")
	public EntityPager<EmailValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all EmailValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(EmailValue.class, queryRules.toArray(new QueryRule[0]));
		List<EmailValue> emailValueCollection = db.find(EmailValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<EmailValue>(start, num, count, emailValueCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_EMAILVALUE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("EmailValue");
	}
}