package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.HtmlValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class HtmlValueService
{
	private static final Logger logger = Logger.getLogger(HtmlValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_HTMLVALUE')")
	public HtmlValue create(HtmlValue htmlValue) throws DatabaseException
	{
		logger.debug("creating HtmlValue");
		db.add(htmlValue);
		return htmlValue;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_HTMLVALUE')")
	public HtmlValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving HtmlValue");
		return db.findById(HtmlValue.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_HTMLVALUE')")
	public void update(HtmlValue htmlValue) throws DatabaseException
	{
		logger.debug("updating HtmlValue");
		db.update(htmlValue);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_HTMLVALUE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting HtmlValue");
		HtmlValue htmlValue = db.findById(HtmlValue.class, id);
		return db.remove(htmlValue) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_HTMLVALUE')")
	public Iterable<HtmlValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all HtmlValue instances");
		return db.find(HtmlValue.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_HTMLVALUE')")
	public EntityPager<HtmlValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all HtmlValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(HtmlValue.class, queryRules.toArray(new QueryRule[0]));
		List<HtmlValue> htmlValueCollection = db.find(HtmlValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<HtmlValue>(start, num, count, htmlValueCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_HTMLVALUE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("HtmlValue");
	}
}