package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.IntValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class IntValueService
{
	private static final Logger logger = Logger.getLogger(IntValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_INTVALUE')")
	public IntValue create(IntValue intValue) throws DatabaseException
	{
		logger.debug("creating IntValue");
		db.add(intValue);
		return intValue;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_INTVALUE')")
	public IntValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving IntValue");
		return db.findById(IntValue.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_INTVALUE')")
	public void update(IntValue intValue) throws DatabaseException
	{
		logger.debug("updating IntValue");
		db.update(intValue);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_INTVALUE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting IntValue");
		IntValue intValue = db.findById(IntValue.class, id);
		return db.remove(intValue) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_INTVALUE')")
	public Iterable<IntValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all IntValue instances");
		return db.find(IntValue.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_INTVALUE')")
	public EntityPager<IntValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all IntValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(IntValue.class, queryRules.toArray(new QueryRule[0]));
		List<IntValue> intValueCollection = db.find(IntValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<IntValue>(start, num, count, intValueCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_INTVALUE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("IntValue");
	}
}