package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.core.MolgenisEntity;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class MolgenisEntityService
{
	private static final Logger logger = Logger.getLogger(MolgenisEntityService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public MolgenisEntity create(MolgenisEntity molgenisEntity) throws DatabaseException
	{
		logger.debug("creating MolgenisEntity");
		db.add(molgenisEntity);
		return molgenisEntity;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public MolgenisEntity read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving MolgenisEntity");
		return db.findById(MolgenisEntity.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public void update(MolgenisEntity molgenisEntity) throws DatabaseException
	{
		logger.debug("updating MolgenisEntity");
		db.update(molgenisEntity);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting MolgenisEntity");
		MolgenisEntity molgenisEntity = db.findById(MolgenisEntity.class, id);
		return db.remove(molgenisEntity) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public Iterable<MolgenisEntity> readAll() throws DatabaseException
	{
		logger.debug("retrieving all MolgenisEntity instances");
		return db.find(MolgenisEntity.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public EntityPager<MolgenisEntity> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all MolgenisEntity instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(MolgenisEntity.class, queryRules.toArray(new QueryRule[0]));
		List<MolgenisEntity> molgenisEntityCollection = db.find(MolgenisEntity.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<MolgenisEntity>(start, num, count, molgenisEntityCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("MolgenisEntity");
	}
}