package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.MrefValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class MrefValueService
{
	private static final Logger logger = Logger.getLogger(MrefValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_MREFVALUE')")
	public MrefValue create(MrefValue mrefValue) throws DatabaseException
	{
		logger.debug("creating MrefValue");
		db.add(mrefValue);
		return mrefValue;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_MREFVALUE')")
	public MrefValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving MrefValue");
		return db.findById(MrefValue.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_MREFVALUE')")
	public void update(MrefValue mrefValue) throws DatabaseException
	{
		logger.debug("updating MrefValue");
		db.update(mrefValue);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_MREFVALUE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting MrefValue");
		MrefValue mrefValue = db.findById(MrefValue.class, id);
		return db.remove(mrefValue) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_MREFVALUE')")
	public Iterable<MrefValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all MrefValue instances");
		return db.find(MrefValue.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_MREFVALUE')")
	public EntityPager<MrefValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all MrefValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(MrefValue.class, queryRules.toArray(new QueryRule[0]));
		List<MrefValue> mrefValueCollection = db.find(MrefValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<MrefValue>(start, num, count, mrefValueCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_MREFVALUE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("MrefValue");
	}
}