package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.ObservationTarget;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ObservationTargetService
{
	private static final Logger logger = Logger.getLogger(ObservationTargetService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_OBSERVATIONTARGET')")
	public ObservationTarget create(ObservationTarget observationTarget) throws DatabaseException
	{
		logger.debug("creating ObservationTarget");
		db.add(observationTarget);
		return observationTarget;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_OBSERVATIONTARGET')")
	public ObservationTarget read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving ObservationTarget");
		return db.findById(ObservationTarget.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_OBSERVATIONTARGET')")
	public void update(ObservationTarget observationTarget) throws DatabaseException
	{
		logger.debug("updating ObservationTarget");
		db.update(observationTarget);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_OBSERVATIONTARGET')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting ObservationTarget");
		ObservationTarget observationTarget = db.findById(ObservationTarget.class, id);
		return db.remove(observationTarget) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_OBSERVATIONTARGET')")
	public Iterable<ObservationTarget> readAll() throws DatabaseException
	{
		logger.debug("retrieving all ObservationTarget instances");
		return db.find(ObservationTarget.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_OBSERVATIONTARGET')")
	public EntityPager<ObservationTarget> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all ObservationTarget instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(ObservationTarget.class, queryRules.toArray(new QueryRule[0]));
		List<ObservationTarget> observationTargetCollection = db.find(ObservationTarget.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<ObservationTarget>(start, num, count, observationTargetCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_OBSERVATIONTARGET')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("ObservationTarget");
	}
}