package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class OntologyTermService
{
	private static final Logger logger = Logger.getLogger(OntologyTermService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_ONTOLOGYTERM')")
	public OntologyTerm create(OntologyTerm ontologyTerm) throws DatabaseException
	{
		logger.debug("creating OntologyTerm");
		db.add(ontologyTerm);
		return ontologyTerm;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_ONTOLOGYTERM')")
	public OntologyTerm read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving OntologyTerm");
		return db.findById(OntologyTerm.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_ONTOLOGYTERM')")
	public void update(OntologyTerm ontologyTerm) throws DatabaseException
	{
		logger.debug("updating OntologyTerm");
		db.update(ontologyTerm);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_ONTOLOGYTERM')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting OntologyTerm");
		OntologyTerm ontologyTerm = db.findById(OntologyTerm.class, id);
		return db.remove(ontologyTerm) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_ONTOLOGYTERM')")
	public Iterable<OntologyTerm> readAll() throws DatabaseException
	{
		logger.debug("retrieving all OntologyTerm instances");
		return db.find(OntologyTerm.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_ONTOLOGYTERM')")
	public EntityPager<OntologyTerm> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all OntologyTerm instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(OntologyTerm.class, queryRules.toArray(new QueryRule[0]));
		List<OntologyTerm> ontologyTermCollection = db.find(OntologyTerm.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<OntologyTerm>(start, num, count, ontologyTermCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_ONTOLOGYTERM')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("OntologyTerm");
	}
}