package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.target.Panel;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PanelService
{
	private static final Logger logger = Logger.getLogger(PanelService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PANEL')")
	public Panel create(Panel panel) throws DatabaseException
	{
		logger.debug("creating Panel");
		db.add(panel);
		return panel;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PANEL')")
	public Panel read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Panel");
		return db.findById(Panel.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PANEL')")
	public void update(Panel panel) throws DatabaseException
	{
		logger.debug("updating Panel");
		db.update(panel);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PANEL')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Panel");
		Panel panel = db.findById(Panel.class, id);
		return db.remove(panel) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PANEL')")
	public Iterable<Panel> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Panel instances");
		return db.find(Panel.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PANEL')")
	public EntityPager<Panel> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Panel instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Panel.class, queryRules.toArray(new QueryRule[0]));
		List<Panel> panelCollection = db.find(Panel.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Panel>(start, num, count, panelCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PANEL')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Panel");
	}
}