package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.Protocol;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ProtocolService
{
	private static final Logger logger = Logger.getLogger(ProtocolService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PROTOCOL')")
	public Protocol create(Protocol protocol) throws DatabaseException
	{
		logger.debug("creating Protocol");
		db.add(protocol);
		return protocol;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROTOCOL')")
	public Protocol read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Protocol");
		return db.findById(Protocol.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PROTOCOL')")
	public void update(Protocol protocol) throws DatabaseException
	{
		logger.debug("updating Protocol");
		db.update(protocol);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PROTOCOL')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Protocol");
		Protocol protocol = db.findById(Protocol.class, id);
		return db.remove(protocol) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROTOCOL')")
	public Iterable<Protocol> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Protocol instances");
		return db.find(Protocol.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROTOCOL')")
	public EntityPager<Protocol> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Protocol instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Protocol.class, queryRules.toArray(new QueryRule[0]));
		List<Protocol> protocolCollection = db.find(Protocol.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Protocol>(start, num, count, protocolCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROTOCOL')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Protocol");
	}
}